package com.zurrtum.create.content.decoration.girder;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.placement.IPlacementHelper;
import com.zurrtum.create.catnip.placement.PlacementOffset;
import com.zurrtum.create.content.equipment.extendoGrip.ExtendoGripItem;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2680;
import net.minecraft.class_3965;
import net.minecraft.class_5134;

public class GirderPlacementHelper implements IPlacementHelper {

    @Override
    public Predicate<class_1799> getItemPredicate() {
        return stack -> stack.method_31574(AllItems.METAL_GIRDER);
    }

    @Override
    public Predicate<class_2680> getStatePredicate() {
        return state -> state.method_27852(AllBlocks.METAL_GIRDER) || state.method_27852(AllBlocks.METAL_GIRDER_ENCASED_SHAFT);
    }

    private boolean canExtendToward(class_2680 state, class_2350 side) {
        class_2351 axis = side.method_10166();
        if (state.method_26204() instanceof GirderBlock) {
            boolean x = state.method_11654(GirderBlock.X);
            boolean z = state.method_11654(GirderBlock.Z);
            if (!x && !z)
                return axis == class_2351.field_11052;
            if (x && z)
                return true;
            return axis == (x ? class_2351.field_11048 : class_2351.field_11051);
        }

        if (state.method_26204() instanceof GirderEncasedShaftBlock)
            return axis != class_2351.field_11052 && axis != state.method_11654(GirderEncasedShaftBlock.HORIZONTAL_AXIS);

        return false;
    }

    private int attachedPoles(class_1937 world, class_2338 pos, class_2350 direction) {
        class_2338 checkPos = pos.method_10093(direction);
        class_2680 state = world.method_8320(checkPos);
        int count = 0;
        while (canExtendToward(state, direction)) {
            count++;
            checkPos = checkPos.method_10093(direction);
            state = world.method_8320(checkPos);
        }
        return count;
    }

    private class_2680 withAxis(class_2680 state, class_2351 axis) {
        if (state.method_26204() instanceof GirderBlock)
            return state.method_11657(GirderBlock.X, axis == class_2351.field_11048).method_11657(GirderBlock.Z, axis == class_2351.field_11051).method_11657(GirderBlock.AXIS, axis);
        if (state.method_26204() instanceof GirderEncasedShaftBlock && axis.method_10179())
            return state.method_11657(GirderEncasedShaftBlock.HORIZONTAL_AXIS, axis == class_2351.field_11048 ? class_2351.field_11051 : class_2351.field_11048);
        return state;
    }

    @Override
    public PlacementOffset getOffset(class_1657 player, class_1937 world, class_2680 state, class_2338 pos, class_3965 ray) {
        List<class_2350> directions = IPlacementHelper.orderedByDistance(pos, ray.method_17784(), dir -> canExtendToward(state, dir));
        for (class_2350 dir : directions) {
            int range = AllConfigs.server().equipment.placementAssistRange.get();
            if (player != null) {
                class_1324 reach = player.method_5996(class_5134.field_47758);
                if (reach != null && reach.method_6196(ExtendoGripItem.singleRangeAttributeModifier.comp_2447()))
                    range += 4;
            }
            int poles = attachedPoles(world, pos, dir);
            if (poles >= range)
                continue;

            class_2338 newPos = pos.method_10079(dir, poles + 1);
            class_2680 newState = world.method_8320(newPos);

            if (!newState.method_45474())
                continue;

            return PlacementOffset.success(newPos, bState -> class_2248.method_9510(withAxis(bState, dir.method_10166()), world, newPos));
        }

        return PlacementOffset.fail();
    }

}
