package com.zurrtum.create.content.decoration.steamWhistle;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.content.decoration.steamWhistle.WhistleBlock.WhistleSize;
import com.zurrtum.create.content.decoration.steamWhistle.WhistleExtenderBlock.WhistleExtenderShape;
import com.zurrtum.create.content.fluids.tank.FluidTankBlockEntity;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.lang.ref.WeakReference;
import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;

public class WhistleBlockEntity extends SmartBlockEntity {

    public WeakReference<FluidTankBlockEntity> source;
    public int pitch;

    public WhistleBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.STEAM_WHISTLE, pos, state);
        source = new WeakReference<>(null);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.STEAM_WHISTLE);
    }

    public void updatePitch() {
        class_2338 currentPos = field_11867.method_10084();
        int newPitch;
        for (newPitch = 0; newPitch <= 24; newPitch += 2) {
            class_2680 blockState = field_11863.method_8320(currentPos);
            if (!blockState.method_27852(AllBlocks.STEAM_WHISTLE_EXTENSION))
                break;
            if (blockState.method_11654(WhistleExtenderBlock.SHAPE) == WhistleExtenderShape.SINGLE) {
                newPitch++;
                break;
            }
            currentPos = currentPos.method_10084();
        }
        if (pitch == newPitch)
            return;
        pitch = newPitch;

        notifyUpdate();

        FluidTankBlockEntity tank = getTank();
        if (tank != null && tank.boiler != null)
            tank.boiler.checkPipeOrganAdvancement(tank);
    }

    @Override
    public void tick() {
        super.tick();
        if (!field_11863.method_8608()) {
            if (isPowered())
                award(AllAdvancements.STEAM_WHISTLE);
        }
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        view.method_71465("Pitch", pitch);
        super.write(view, clientPacket);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        pitch = view.method_71424("Pitch", 0);
        super.read(view, clientPacket);
    }

    public boolean isPowered() {
        return method_11010().method_61767(WhistleBlock.POWERED, false);
    }

    public WhistleSize getOctave() {
        return method_11010().method_61767(WhistleBlock.SIZE, WhistleSize.MEDIUM);
    }

    public int getPitchId() {
        return pitch + 100 * method_11010().method_61767(WhistleBlock.SIZE, WhistleSize.MEDIUM).ordinal();
    }

    public FluidTankBlockEntity getTank() {
        FluidTankBlockEntity tank = source.get();
        if (tank == null || tank.method_11015()) {
            if (tank != null)
                source = new WeakReference<>(null);
            class_2350 facing = WhistleBlock.getAttachedDirection(method_11010());
            class_2586 be = field_11863.method_8321(field_11867.method_10093(facing));
            if (be instanceof FluidTankBlockEntity tankBe)
                source = new WeakReference<>(tank = tankBe);
        }
        if (tank == null)
            return null;
        return tank.getControllerBE();
    }

}
