package com.zurrtum.create.content.equipment.bell;

import com.zurrtum.create.AllShapes;
import com.zurrtum.create.foundation.block.IBE;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3468;
import net.minecraft.class_3709;
import net.minecraft.class_3726;
import net.minecraft.class_3867;
import net.minecraft.class_3965;
import net.minecraft.class_5558;
import net.minecraft.class_9904;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBellBlock<BE extends AbstractBellBlockEntity> extends class_3709 implements IBE<BE> {

    public AbstractBellBlock(class_2251 properties) {
        super(properties);
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 reader, class_2338 pos, class_3726 selection) {
        class_2350 facing = state.method_11654(field_16324);
        return switch (state.method_11654(field_16326)) {
            case field_17099 -> AllShapes.BELL_CEILING.get(facing);
            case field_17101 -> AllShapes.BELL_DOUBLE_WALL.get(facing);
            case field_17098 -> AllShapes.BELL_FLOOR.get(facing);
            case field_17100 -> AllShapes.BELL_WALL.get(facing);
        };
    }

    @Override
    public void method_9612(
        class_2680 pState,
        class_1937 pLevel,
        class_2338 pPos,
        class_2248 pBlock,
        @Nullable class_9904 wireOrientation,
        boolean pIsMoving
    ) {
        if (pLevel.method_8608())
            return;
        boolean shouldPower = pLevel.method_49803(pPos);
        if (shouldPower == pState.method_11654(field_20648))
            return;
        pLevel.method_8652(pPos, pState.method_11657(field_20648, shouldPower), class_2248.field_31036);
        if (!shouldPower)
            return;
        class_2350 facing = pState.method_11654(field_16324);
        class_3867 type = pState.method_11654(field_16326);
        ring(pLevel, pPos, type == class_3867.field_17099 || type == class_3867.field_17098 ? facing : facing.method_10170(), null);
    }

    @Override
    public boolean method_19285(class_1937 world, class_2680 state, class_3965 hit, @Nullable class_1657 player, boolean flag) {
        class_2338 pos = hit.method_17777();
        class_2350 direction = hit.method_17780();
        if (direction == null)
            direction = world.method_8320(pos).method_11654(field_16324);
        if (!this.canRingFrom(state, direction, hit.method_17784().field_1351 - pos.method_10264()))
            return false;
        return ring(world, pos, direction, player);
    }

    protected boolean ring(class_1937 world, class_2338 pos, class_2350 direction, class_1657 player) {
        BE be = getBlockEntity(world, pos);
        if (world.method_8608())
            return true;
        if (be == null || !be.ring(world, pos, direction))
            return false;
        playSound(world, pos);
        if (player != null)
            player.method_7281(class_3468.field_19255);
        return true;
    }

    public boolean canRingFrom(class_2680 state, class_2350 hitDir, double heightChange) {
        if (hitDir.method_10166() == class_2350.class_2351.field_11052)
            return false;
        if (heightChange > 0.8124)
            return false;

        class_2350 direction = state.method_11654(field_16324);
        class_3867 bellAttachment = state.method_11654(field_16326);
        return switch (bellAttachment) {
            case field_17098, field_17099 -> direction.method_10166() == hitDir.method_10166();
            case field_17100, field_17101 -> direction.method_10166() != hitDir.method_10166();
        };
    }

    @Override
    @Nullable
    public class_2586 method_10123(class_2338 p_152198_, class_2680 p_152199_) {
        return IBE.super.method_10123(p_152198_, p_152199_);
    }

    @Override
    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 p_152194_, class_2680 p_152195_, class_2591<T> p_152196_) {
        return IBE.super.method_31645(p_152194_, p_152195_, p_152196_);
    }

    public abstract void playSound(class_1937 world, class_2338 pos);

}
