package com.zurrtum.create.content.equipment.bell;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllSoundEvents;
import net.minecraft.class_10225;
import net.minecraft.class_1750;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_4538;
import net.minecraft.class_5819;

public class PeculiarBellBlock extends AbstractBellBlock<PeculiarBellBlockEntity> {

    public PeculiarBellBlock(class_2251 properties) {
        super(properties);
    }

    @Override
    public class_2591<? extends PeculiarBellBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.PECULIAR_BELL;
    }

    @Override
    public Class<PeculiarBellBlockEntity> getBlockEntityClass() {
        return PeculiarBellBlockEntity.class;
    }

    @Override
    public void playSound(class_1937 world, class_2338 pos) {
        AllSoundEvents.PECULIAR_BELL_USE.playOnServer(world, pos, 2f, 0.94f);
    }

    @Override
    public class_2680 method_9605(class_1750 ctx) {
        class_2680 newState = super.method_9605(ctx);
        if (newState == null)
            return null;

        class_1937 world = ctx.method_8045();
        class_2338 pos = ctx.method_8037();
        return tryConvert(world, pos, newState, world.method_8320(pos.method_10093(class_2350.field_11033)));
    }

    @Override
    public class_2680 method_9559(
        class_2680 state,
        class_4538 world,
        class_10225 tickView,
        class_2338 currentPos,
        class_2350 facing,
        class_2338 facingPos,
        class_2680 facingState,
        class_5819 random
    ) {
        class_2680 newState = super.method_9559(state, world, tickView, currentPos, facing, facingPos, facingState, random);
        if (facing != class_2350.field_11033)
            return newState;

        return tryConvert((class_1936) world, currentPos, newState, facingState);
    }

    protected class_2680 tryConvert(class_1936 world, class_2338 pos, class_2680 state, class_2680 underState) {
        if (!state.method_27852(AllBlocks.PECULIAR_BELL))
            return state;

        class_2248 underBlock = underState.method_26204();
        if (!(class_2246.field_22089.equals(underBlock) || class_2246.field_23860.equals(underBlock)))
            return state;

        if (world.method_8608()) {
            spawnConversionParticles(world, pos);
        } else if (world instanceof class_1937 worldIn) {
            AllSoundEvents.HAUNTED_BELL_CONVERT.playOnServer(worldIn, pos);
        }

        return AllBlocks.HAUNTED_BELL.method_9564().method_11657(HauntedBellBlock.field_16324, state.method_11654(field_16324))
            .method_11657(HauntedBellBlock.field_16326, state.method_11654(field_16326)).method_11657(HauntedBellBlock.field_20648, state.method_11654(field_20648));
    }

    public void spawnConversionParticles(class_1936 world, class_2338 blockPos) {
        class_5819 random = world.method_8409();
        int num = random.method_43048(10) + 15;
        for (int i = 0; i < num; i++) {
            float pitch = random.method_43057() * 120 - 90;
            float yaw = random.method_43057() * 360;
            class_243 vel = class_243.method_1030(pitch, yaw).method_1021(random.method_43058() * 0.1 + 0.1);
            class_243 pos = class_243.method_24953(blockPos);
            world.method_8406(class_2398.field_22246, pos.field_1352, pos.field_1351, pos.field_1350, vel.field_1352, vel.field_1351, vel.field_1350);
        }
    }

}