package com.zurrtum.create.content.equipment.potatoCannon;

import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.api.equipment.potatoCannon.PotatoProjectileBlockHitAction;
import com.zurrtum.create.api.registry.CreateRegistries;
import net.minecraft.class_1540;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3965;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

import static com.zurrtum.create.Create.MOD_ID;

public class AllPotatoProjectileBlockHitActions {
    public static void register() {
        register("plant_crop", PlantCrop.CODEC);
        register("place_block_on_ground", PlaceBlockOnGround.CODEC);
    }

    private static void register(String name, MapCodec<? extends PotatoProjectileBlockHitAction> codec) {
        class_2378.method_10230(CreateRegistries.POTATO_PROJECTILE_BLOCK_HIT_ACTION, class_2960.method_60655(MOD_ID, name), codec);
    }

    public record PlantCrop(class_6880<class_2248> cropBlock) implements PotatoProjectileBlockHitAction {
        public static final MapCodec<PlantCrop> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(class_7923.field_41175.method_40294()
            .fieldOf("block").forGetter(PlantCrop::cropBlock)).apply(instance, PlantCrop::new));

        @SuppressWarnings("deprecation")
        public PlantCrop(class_2248 cropBlock) {
            this(cropBlock.method_40142());
        }

        @Override
        public boolean execute(class_1936 level, class_1799 projectile, class_3965 ray) {
            if (level.method_8608())
                return true;

            class_2338 hitPos = ray.method_17777();
            if (level instanceof class_1937 l && !l.method_8477(hitPos))
                return true;
            class_2350 face = ray.method_17780();
            if (face != class_2350.field_11036)
                return false;
            class_2338 placePos = hitPos.method_10093(face);
            if (!level.method_8320(placePos).method_45474())
                return false;
            //TODO
            //            if (!(cropBlock.value() instanceof SpecialPlantable specialPlantable))
            //                return false;
            //            if (specialPlantable.canPlacePlantAtPosition(projectile, level, placePos, null))
            //                specialPlantable.spawnPlantAtPosition(projectile, level, placePos, null);
            return true;
        }

        @Override
        public MapCodec<? extends PotatoProjectileBlockHitAction> codec() {
            return CODEC;
        }
    }

    public record PlaceBlockOnGround(class_6880<class_2248> block) implements PotatoProjectileBlockHitAction {
        public static final MapCodec<PlaceBlockOnGround> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(class_7923.field_41175.method_40294()
            .fieldOf("block").forGetter(PlaceBlockOnGround::block)).apply(instance, PlaceBlockOnGround::new));

        @SuppressWarnings("deprecation")
        public PlaceBlockOnGround(class_2248 block) {
            this(block.method_40142());
        }

        @Override
        public boolean execute(class_1936 levelAccessor, class_1799 projectile, class_3965 ray) {
            if (levelAccessor.method_8608())
                return true;

            class_2338 hitPos = ray.method_17777();
            if (levelAccessor instanceof class_1937 l && !l.method_8477(hitPos))
                return true;
            class_2350 face = ray.method_17780();
            class_2338 placePos = hitPos.method_10093(face);
            if (!levelAccessor.method_8320(placePos).method_45474())
                return false;

            if (face == class_2350.field_11036) {
                levelAccessor.method_8652(placePos, block.comp_349().method_9564(), class_2248.field_31036);
            } else if (levelAccessor instanceof class_1937 level) {
                double y = ray.method_17777().method_10264() - 0.5;
                if (!level.method_22347(placePos.method_10084()))
                    y = Math.min(y, placePos.method_10264());
                if (!level.method_22347(placePos.method_10074()))
                    y = Math.max(y, placePos.method_10264());

                class_1540 falling = new class_1540(
                    level,
                    placePos.method_10263() + 0.5,
                    y,
                    placePos.method_10260() + 0.5,
                    block.comp_349().method_9564()
                );
                falling.field_7192 = 1;
                level.method_8649(falling);
            }

            return true;
        }

        @Override
        public MapCodec<? extends PotatoProjectileBlockHitAction> codec() {
            return CODEC;
        }
    }
}
