package com.zurrtum.create.content.equipment.symmetryWand.mirror;

import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.infrastructure.component.SymmetryMirror;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3542;

public class CrossPlaneMirror extends SymmetryMirror {
    public enum Align implements class_3542 {
        Y("y"),
        D("d");

        private final String name;

        private Align(String name) {
            this.name = name;
        }

        @Override
        public String method_15434() {
            return name;
        }

        @Override
        public String toString() {
            return name;
        }
    }

    public CrossPlaneMirror(class_243 pos) {
        super(pos);
        orientation = Align.Y;
    }

    @Override
    protected void setOrientation() {
        if (orientationIndex < 0)
            orientationIndex += Align.values().length;
        if (orientationIndex >= Align.values().length)
            orientationIndex -= Align.values().length;
        orientation = Align.values()[orientationIndex];
    }

    @Override
    public void setOrientation(int index) {
        this.orientation = Align.values()[index];
        orientationIndex = index;
    }

    @Override
    public Map<class_2338, Pair<class_2350, class_2680>> process(class_2338 position, Pair<class_2350, class_2680> pair) {
        Map<class_2338, Pair<class_2350, class_2680>> result = new HashMap<>();

        class_2350 side = pair.getFirst();
        class_2680 block = pair.getSecond();
        switch ((Align) orientation) {
            case D:
                result.put(flipD1(position), Pair.of(flipD1(side), flipD1(block)));
                result.put(flipD2(position), Pair.of(flipD2(side), flipD2(block)));
                result.put(flipD1(flipD2(position)), Pair.of(flipD1D2(side), flipD1(flipD2(block))));
                break;
            case Y:
                result.put(flipX(position), Pair.of(flipX(side), flipX(block)));
                result.put(flipZ(position), Pair.of(flipZ(side), flipZ(block)));
                result.put(flipX(flipZ(position)), Pair.of(flipXZ(side), flipX(flipZ(block))));
                break;
            default:
                break;
        }

        return result;
    }

    @Override
    public Set<class_2338> process(class_2338 position) {
        Set<class_2338> positions = new HashSet<>();
        switch ((Align) orientation) {
            case D:
                positions.add(flipD1(position));
                positions.add(flipD2(position));
                positions.add(flipD1(flipD2(position)));
                break;
            case Y:
                positions.add(flipX(position));
                positions.add(flipZ(position));
                positions.add(flipX(flipZ(position)));
                break;
            default:
                break;
        }
        return positions;
    }

    @Override
    public String typeName() {
        return CROSS_PLANE;
    }
}
