package com.zurrtum.create.content.equipment.wrench;

import com.zurrtum.create.AllBlockTags;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllSoundEvents;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1688;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public class WrenchItem extends class_1792 {

    public WrenchItem(class_1793 properties) {
        super(properties);
    }

    @Override
    @NotNull
    public class_1269 method_7884(class_1838 context) {
        class_1657 player = context.method_8036();
        if (player == null || !player.method_7294())
            return super.method_7884(context);

        class_2680 state = context.method_8045().method_8320(context.method_8037());
        class_2248 block = state.method_26204();

        if (!(block instanceof IWrenchable actor)) {
            if (player.method_5715() && canWrenchPickup(state))
                return onItemUseOnOther(context);
            return super.method_7884(context);
        }

        if (player.method_5715())
            return actor.onSneakWrenched(state, context);
        return actor.onWrenched(state, context);
    }

    private boolean canWrenchPickup(class_2680 state) {
        return state.method_26164(AllBlockTags.WRENCH_PICKUP);
    }

    private class_1269 onItemUseOnOther(class_1838 context) {
        class_1657 player = context.method_8036();
        class_1937 world = context.method_8045();
        class_2338 pos = context.method_8037();
        class_2680 state = world.method_8320(pos);
        if (!(world instanceof class_3218 serverWorld))
            return class_1269.field_5812;
        if (player != null && !player.method_68878())
            class_2248.method_9609(state, serverWorld, pos, world.method_8321(pos), player, context.method_8041())
                .forEach(itemStack -> player.method_31548().method_7398(itemStack));
        state.method_26180(serverWorld, pos, class_1799.field_8037, true);
        world.method_22352(pos, false);
        AllSoundEvents.WRENCH_REMOVE.playOnServer(world, pos, 1, world.field_9229.method_43057() * .5f + .5f);
        return class_1269.field_5812;
    }

    public static boolean wrenchInstaKillsMinecarts(class_3222 player, class_1297 target) {
        if (!(target instanceof class_1688 minecart))
            return false;
        class_1799 heldItem = player.method_6047();
        if (!heldItem.method_31574(AllItems.WRENCH))
            return false;
        if (player.method_68878())
            return false;
        minecart.method_64397(player.method_51469(), minecart.method_48923().method_48802(player), 100);
        return true;
    }
}
