package com.zurrtum.create.content.fluids.drain;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.content.equipment.wrench.IWrenchable;
import com.zurrtum.create.content.fluids.transfer.GenericItemEmptying;
import com.zurrtum.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.zurrtum.create.foundation.advancement.AdvancementBehaviour;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.blockEntity.ComparatorUtil;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.fluid.FluidHelper;
import com.zurrtum.create.infrastructure.fluids.FluidInventory;
import com.zurrtum.create.infrastructure.fluids.FluidInventoryProvider;
import com.zurrtum.create.infrastructure.items.ItemInventoryProvider;
import net.minecraft.class_10;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3726;
import net.minecraft.class_3965;

public class ItemDrainBlock extends class_2248 implements IWrenchable, IBE<ItemDrainBlockEntity>, ItemInventoryProvider<ItemDrainBlockEntity>, FluidInventoryProvider<ItemDrainBlockEntity> {

    public ItemDrainBlock(class_2251 p_i48440_1_) {
        super(p_i48440_1_);
    }

    @Override
    public class_1263 getInventory(class_1936 world, class_2338 pos, class_2680 state, ItemDrainBlockEntity blockEntity, class_2350 context) {
        if (context != null && context.method_10166().method_10179())
            return blockEntity.itemHandlers.get(context);
        return null;
    }

    @Override
    public FluidInventory getFluidInventory(class_1936 world, class_2338 pos, class_2680 state, ItemDrainBlockEntity blockEntity, class_2350 context) {
        return blockEntity.internalTank.getCapability();
    }

    @Override
    protected class_1269 method_55765(
        class_1799 stack,
        class_2680 state,
        class_1937 level,
        class_2338 pos,
        class_1657 player,
        class_1268 hand,
        class_3965 hitResult
    ) {
        if (stack.method_7909() instanceof class_1747 && !FluidHelper.hasFluidInventory(stack))
            return class_1269.field_52423;

        return onBlockEntityUseItemOn(
            level, pos, be -> {
                if (!stack.method_7960()) {
                    be.internalTank.allowInsertion();
                    class_1269 tryExchange = tryExchange(level, player, hand, stack, be);
                    be.internalTank.forbidInsertion();
                    if (tryExchange.method_23665())
                        return tryExchange;
                }

                class_1799 heldItemStack = be.getHeldItemStack();
                if (!level.method_8608() && !heldItemStack.method_7960()) {
                    player.method_31548().method_7398(heldItemStack);
                    be.heldItem = null;
                    be.notifyUpdate();
                }
                return class_1269.field_5812;
            }
        );
    }

    @Override
    public void method_9502(class_1922 worldIn, class_1297 entityIn) {
        super.method_9502(worldIn, entityIn);
        if (!(entityIn instanceof class_1542 itemEntity))
            return;
        if (!entityIn.method_5805())
            return;
        if (entityIn.method_73183().method_8608())
            return;

        DirectBeltInputBehaviour inputBehaviour = BlockEntityBehaviour.get(worldIn, entityIn.method_24515(), DirectBeltInputBehaviour.TYPE);
        if (inputBehaviour == null)
            return;
        class_243 deltaMovement = entityIn.method_18798().method_18805(1, 0, 1).method_1029();
        class_2350 nearest = class_2350.method_10142(deltaMovement.field_1352, deltaMovement.field_1351, deltaMovement.field_1350);
        class_1799 remainder = inputBehaviour.handleInsertion(itemEntity.method_6983(), nearest, false);
        itemEntity.method_6979(remainder);
        if (remainder.method_7960())
            itemEntity.method_31472();
    }

    protected class_1269 tryExchange(class_1937 worldIn, class_1657 player, class_1268 handIn, class_1799 heldItem, ItemDrainBlockEntity be) {
        if (FluidHelper.tryEmptyItemIntoBE(worldIn, player, handIn, heldItem, be))
            return class_1269.field_5812;
        if (GenericItemEmptying.canItemBeEmptied(worldIn, heldItem))
            return class_1269.field_5812;
        return class_1269.field_52423;
    }

    @Override
    public class_265 method_9530(class_2680 p_220053_1_, class_1922 p_220053_2_, class_2338 p_220053_3_, class_3726 p_220053_4_) {
        return AllShapes.CASING_13PX.get(class_2350.field_11036);
    }

    @Override
    public Class<ItemDrainBlockEntity> getBlockEntityClass() {
        return ItemDrainBlockEntity.class;
    }

    @Override
    public void method_9567(class_1937 pLevel, class_2338 pPos, class_2680 pState, class_1309 pPlacer, class_1799 pStack) {
        super.method_9567(pLevel, pPos, pState, pPlacer, pStack);
        AdvancementBehaviour.setPlacedBy(pLevel, pPos, pPlacer);
    }

    @Override
    public class_2591<? extends ItemDrainBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.ITEM_DRAIN;
    }

    @Override
    public boolean method_9498(class_2680 state) {
        return true;
    }

    @Override
    public int method_9572(class_2680 blockState, class_1937 worldIn, class_2338 pos, class_2350 direction) {
        return ComparatorUtil.levelOfSmartFluidTank(worldIn, pos);
    }

    @Override
    protected boolean method_9516(class_2680 state, class_10 pathComputationType) {
        return false;
    }

}
