package com.zurrtum.create.content.fluids.pipes;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.api.schematic.requirement.SpecialBlockItemRequirement;
import com.zurrtum.create.content.fluids.FluidTransportBehaviour;
import com.zurrtum.create.content.schematics.requirement.ItemRequirement;
import com.zurrtum.create.foundation.block.IBE;
import net.minecraft.class_10;
import net.minecraft.class_1269;
import net.minecraft.class_1750;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689.class_2690;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3737;

public class GlassFluidPipeBlock extends AxisPipeBlock implements IBE<StraightPipeBlockEntity>, class_3737, SpecialBlockItemRequirement {

    public static final class_2746 ALT = class_2746.method_11825("alt");

    public GlassFluidPipeBlock(class_2251 p_i48339_1_) {
        super(p_i48339_1_);
        method_9590(method_9564().method_11657(ALT, false).method_11657(class_2741.field_12508, false));
    }

    @Override
    protected void method_9515(class_2690<class_2248, class_2680> p_206840_1_) {
        super.method_9515(p_206840_1_.method_11667(ALT, class_2741.field_12508));
    }

    @Override
    public class_1269 onWrenched(class_2680 state, class_1838 context) {
        if (tryRemoveBracket(context))
            return class_1269.field_5812;
        class_2680 newState;
        class_1937 world = context.method_8045();
        class_2338 pos = context.method_8037();
        FluidTransportBehaviour.cacheFlows(world, pos);
        newState = toRegularPipe(world, pos, state).method_11657(class_2741.field_12508, state.method_11654(class_2741.field_12508));
        world.method_8652(pos, newState, class_2248.field_31036);
        FluidTransportBehaviour.loadFlows(world, pos);
        return class_1269.field_5812;
    }

    @Override
    public class_2680 method_9605(class_1750 context) {
        class_3610 ifluidstate = context.method_8045().method_8316(context.method_8037());
        class_2680 state = super.method_9605(context);
        return state == null ? null : state.method_11657(class_2741.field_12508, ifluidstate.method_15772() == class_3612.field_15910);
    }

    @Override
    public class_3610 method_9545(class_2680 state) {
        return state.method_11654(class_2741.field_12508) ? class_3612.field_15910.method_15729(false) : class_3612.field_15906.method_15785();
    }

    @Override
    public ItemRequirement getRequiredItems(class_2680 state, class_2586 be) {
        return ItemRequirement.of(AllBlocks.FLUID_PIPE.method_9564(), be);
    }

    @Override
    protected boolean method_9516(class_2680 state, class_10 pathComputationType) {
        return false;
    }

    @Override
    public Class<StraightPipeBlockEntity> getBlockEntityClass() {
        return StraightPipeBlockEntity.class;
    }

    @Override
    public class_2591<? extends StraightPipeBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.GLASS_FLUID_PIPE;
    }

}
