package com.zurrtum.create.content.fluids.pipes;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.content.fluids.FluidPropagator;
import com.zurrtum.create.content.fluids.pipes.StraightPipeBlockEntity.StraightPipeFluidTransportBehaviour;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;

public class SmartFluidPipeBlockEntity extends SmartBlockEntity {

    private ServerFilteringBehaviour filter;

    public SmartFluidPipeBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.SMART_FLUID_PIPE, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        behaviours.add(new SmartPipeBehaviour(this));
        behaviours.add(filter = new ServerFilteringBehaviour(this).forFluids().withCallback(this::onFilterChanged));
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return FluidPropagator.getSharedTriggers();
    }

    private void onFilterChanged(class_1799 newFilter) {
        if (!field_11863.method_8608())
            FluidPropagator.propagateChangedPipe(field_11863, field_11867, method_11010());
    }

    class SmartPipeBehaviour extends StraightPipeFluidTransportBehaviour {

        public SmartPipeBehaviour(SmartBlockEntity be) {
            super(be);
        }

        @Override
        public boolean canPullFluidFrom(FluidStack fluid, class_2680 state, class_2350 direction) {
            if (fluid.isEmpty() || filter != null && filter.test(fluid))
                return super.canPullFluidFrom(fluid, state, direction);
            return false;
        }

        @Override
        public boolean canHaveFlowToward(class_2680 state, class_2350 direction) {
            return state.method_26204() instanceof SmartFluidPipeBlock && SmartFluidPipeBlock.getPipeAxis(state) == direction.method_10166();
        }

    }
}