package com.zurrtum.create.content.fluids.tank;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.api.connectivity.ConnectivityHandler;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.animation.LerpedFloat.Chaser;
import com.zurrtum.create.content.fluids.tank.FluidTankBlock.Shape;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.IMultiBlockEntityContainer;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.fluid.FluidTank;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import com.zurrtum.create.infrastructure.fluids.BucketFluidInventory;
import com.zurrtum.create.infrastructure.fluids.FluidInventory;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.Objects;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;

import static java.lang.Math.abs;

public class FluidTankBlockEntity extends SmartBlockEntity implements IMultiBlockEntityContainer.Fluid {

    private static final int MAX_SIZE = 3;

    public FluidInventory fluidCapability;
    protected boolean forceFluidLevelUpdate;
    protected FluidTank tankInventory;
    protected class_2338 controller;
    protected class_2338 lastKnownPos;
    protected boolean updateConnectivity;
    protected boolean updateCapability;
    public boolean window;
    protected int luminosity;
    protected int width;
    protected int height;

    public BoilerData boiler;

    private static final int SYNC_RATE = 8;
    protected int syncCooldown;
    protected boolean queuedSync;

    // For rendering purposes only
    private LerpedFloat fluidLevel;

    public FluidTankBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        tankInventory = createInventory();
        forceFluidLevelUpdate = true;
        updateConnectivity = false;
        updateCapability = false;
        window = true;
        height = 1;
        width = 1;
        boiler = new BoilerData();
        refreshCapability();
    }

    public static FluidTankBlockEntity tank(class_2338 pos, class_2680 state) {
        return new FluidTankBlockEntity(AllBlockEntityTypes.FLUID_TANK, pos, state);
    }

    @Override
    public void method_66473(class_2338 pos, class_2680 oldState) {
        super.method_66473(pos, oldState);
        field_11863.method_8544(pos);
        ConnectivityHandler.splitMulti(this);
    }

    protected FluidTank createInventory() {
        return new FluidTankInventory(getCapacityMultiplier());
    }

    protected void updateConnectivity() {
        updateConnectivity = false;
        if (field_11863.method_8608())
            return;
        if (!isController())
            return;
        ConnectivityHandler.formMulti(this);
    }

    @Override
    public void tick() {
        super.tick();
        if (syncCooldown > 0) {
            syncCooldown--;
            if (syncCooldown == 0 && queuedSync)
                sendData();
        }

        if (lastKnownPos == null)
            lastKnownPos = field_11867;
        else if (!lastKnownPos.equals(field_11867) && field_11867 != null) {
            onPositionChanged();
            return;
        }

        if (updateCapability) {
            updateCapability = false;
            refreshCapability();
        }
        if (updateConnectivity)
            updateConnectivity();
        if (fluidLevel != null)
            fluidLevel.tickChaser();
        if (isController())
            boiler.tick(this);
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (isController())
            boiler.updateOcclusion(this);
    }

    @Override
    public class_2338 getLastKnownPos() {
        return lastKnownPos;
    }

    @Override
    public boolean isController() {
        return controller == null || field_11867.method_10263() == controller.method_10263() && field_11867.method_10264() == controller.method_10264() && field_11867.method_10260() == controller.method_10260();
    }

    @Override
    public void initialize() {
        super.initialize();
        sendData();
        if (field_11863.method_8608())
            invalidateRenderBoundingBox();
    }

    private void onPositionChanged() {
        removeController(true);
        lastKnownPos = field_11867;
    }

    protected void onFluidStackChanged(FluidStack newFluidStack) {
        if (!method_11002())
            return;

        int luminosity = (int) (newFluidStack.getFluid().method_15785().method_15759().method_26213() / 1.2f);
        boolean reversed = false;
        int maxY = (int) ((getFillState() * height) + 1);

        for (int yOffset = 0; yOffset < height; yOffset++) {
            boolean isBright = reversed ? (height - yOffset <= maxY) : (yOffset < maxY);
            int actualLuminosity = isBright ? luminosity : luminosity > 0 ? 1 : 0;

            for (int xOffset = 0; xOffset < width; xOffset++) {
                for (int zOffset = 0; zOffset < width; zOffset++) {
                    class_2338 pos = this.field_11867.method_10069(xOffset, yOffset, zOffset);
                    FluidTankBlockEntity tankAt = ConnectivityHandler.partAt(method_11017(), field_11863, pos);
                    if (tankAt == null)
                        continue;
                    field_11863.method_8455(pos, tankAt.method_11010().method_26204());
                    if (tankAt.luminosity == actualLuminosity)
                        continue;
                    tankAt.setLuminosity(actualLuminosity);
                }
            }
        }

        if (!field_11863.method_8608()) {
            method_5431();
            sendData();
        }

        if (isVirtual()) {
            if (fluidLevel == null)
                fluidLevel = LerpedFloat.linear().startWithValue(getFillState());
            fluidLevel.chase(getFillState(), .5f, Chaser.EXP);
        }
    }

    protected void setLuminosity(int luminosity) {
        if (field_11863.method_8608())
            return;
        if (this.luminosity == luminosity)
            return;
        this.luminosity = luminosity;
        updateStateLuminosity();
        sendData();
    }

    protected void updateStateLuminosity() {
        if (field_11863.method_8608())
            return;
        int actualLuminosity = luminosity;
        FluidTankBlockEntity controllerBE = getControllerBE();
        if (controllerBE == null || !controllerBE.window)
            actualLuminosity = 0;
        refreshBlockState();
        class_2680 state = method_11010();
        if (state.method_11654(FluidTankBlock.LIGHT_LEVEL) != actualLuminosity) {
            field_11863.method_8652(field_11867, state.method_11657(FluidTankBlock.LIGHT_LEVEL, actualLuminosity), 23);
        }
    }

    @SuppressWarnings("unchecked")
    @Override
    public FluidTankBlockEntity getControllerBE() {
        if (isController() || !method_11002())
            return this;
        class_2586 blockEntity = field_11863.method_8321(controller);
        if (blockEntity instanceof FluidTankBlockEntity)
            return (FluidTankBlockEntity) blockEntity;
        return null;
    }

    public void applyFluidTankSize(int blocks) {
        int capacity = blocks * getCapacityMultiplier();
        tankInventory.setCapacity(capacity);
        FluidStack stack = tankInventory.getFluid();
        if (stack.getAmount() > capacity) {
            stack.setAmount(capacity);
            tankInventory.markDirty();
        }
        forceFluidLevelUpdate = true;
    }

    public void removeController(boolean keepFluids) {
        if (field_11863.method_8608())
            return;
        updateConnectivity = true;
        if (!keepFluids)
            applyFluidTankSize(1);
        controller = null;
        width = 1;
        height = 1;
        boiler.clear();
        onFluidStackChanged(tankInventory.getFluid());

        class_2680 state = method_11010();
        if (FluidTankBlock.isTank(state)) {
            state = state.method_11657(FluidTankBlock.BOTTOM, true);
            state = state.method_11657(FluidTankBlock.TOP, true);
            state = state.method_11657(FluidTankBlock.SHAPE, window ? Shape.WINDOW : Shape.PLAIN);
            method_10997().method_8652(field_11867, state, class_2248.field_31028 | class_2248.field_31029 | class_2248.field_31031);
        }

        refreshCapability();
        method_5431();
        sendData();
    }

    public void toggleWindows() {
        FluidTankBlockEntity be = getControllerBE();
        if (be == null)
            return;
        if (be.boiler.isActive())
            return;
        be.setWindows(!be.window);
    }

    public void updateBoilerTemperature() {
        FluidTankBlockEntity be = getControllerBE();
        if (be == null)
            return;
        if (!be.boiler.isActive())
            return;
        be.boiler.needsHeatLevelUpdate = true;
    }

    public void sendDataImmediately() {
        syncCooldown = 0;
        queuedSync = false;
        sendData();
    }

    @Override
    public void sendData() {
        if (syncCooldown > 0) {
            queuedSync = true;
            return;
        }
        super.sendData();
        queuedSync = false;
        syncCooldown = SYNC_RATE;
    }

    public void setWindows(boolean window) {
        this.window = window;
        for (int yOffset = 0; yOffset < height; yOffset++) {
            for (int xOffset = 0; xOffset < width; xOffset++) {
                for (int zOffset = 0; zOffset < width; zOffset++) {

                    class_2338 pos = this.field_11867.method_10069(xOffset, yOffset, zOffset);
                    class_2680 blockState = field_11863.method_8320(pos);
                    if (!FluidTankBlock.isTank(blockState))
                        continue;

                    Shape shape = Shape.PLAIN;
                    if (window) {
                        // SIZE 1: Every tank has a window
                        if (width == 1)
                            shape = Shape.WINDOW;
                        // SIZE 2: Every tank has a corner window
                        if (width == 2)
                            shape = xOffset == 0 ? zOffset == 0 ? Shape.WINDOW_NW : Shape.WINDOW_SW : zOffset == 0 ? Shape.WINDOW_NE : Shape.WINDOW_SE;
                        // SIZE 3: Tanks in the center have a window
                        if (width == 3 && abs(abs(xOffset) - abs(zOffset)) == 1)
                            shape = Shape.WINDOW;
                    }

                    field_11863.method_8652(
                        pos,
                        blockState.method_11657(FluidTankBlock.SHAPE, shape),
                        class_2248.field_31028 | class_2248.field_31029 | class_2248.field_31031
                    );
                    class_2586 be = field_11863.method_8321(pos);
                    if (be instanceof FluidTankBlockEntity tankAt)
                        tankAt.updateStateLuminosity();
                    field_11863.method_8398().method_12130().method_15513(pos);
                }
            }
        }
    }

    public void updateBoilerState() {
        if (!isController())
            return;

        boolean wasBoiler = boiler.isActive();
        boolean changed = boiler.evaluate(this);

        if (wasBoiler != boiler.isActive()) {
            if (boiler.isActive())
                setWindows(false);

            for (int yOffset = 0; yOffset < height; yOffset++)
                for (int xOffset = 0; xOffset < width; xOffset++)
                    for (int zOffset = 0; zOffset < width; zOffset++)
                        if (field_11863.method_8321(field_11867.method_10069(xOffset, yOffset, zOffset)) instanceof FluidTankBlockEntity fbe)
                            fbe.refreshCapability();
        }

        if (changed) {
            notifyUpdate();
            boiler.checkPipeOrganAdvancement(this);
        }
    }

    @Override
    public void setController(class_2338 controller) {
        if (field_11863.method_8608() && !isVirtual())
            return;
        if (controller.equals(this.controller))
            return;
        this.controller = controller;
        refreshCapability();
        method_5431();
        sendData();
    }

    public void refreshCapability() {
        fluidCapability = handlerForCapability();
    }

    private FluidInventory handlerForCapability() {
        return isController() ? (boiler.isActive() ? boiler.createHandler() : tankInventory) : ((getControllerBE() != null) ? getControllerBE().handlerForCapability() : new FluidTank(
            0));
    }

    @Override
    public class_2338 getController() {
        return isController() ? field_11867 : controller;
    }

    @Override
    protected class_238 createRenderBoundingBox() {
        if (isController())
            return super.createRenderBoundingBox().method_1012(width - 1, height - 1, width - 1);
        else
            return super.createRenderBoundingBox();
    }

    @Nullable
    public FluidTankBlockEntity getOtherFluidTankBlockEntity(class_2350 direction) {
        class_2586 otherBE = field_11863.method_8321(field_11867.method_10093(direction));
        if (otherBE instanceof FluidTankBlockEntity)
            return (FluidTankBlockEntity) otherBE;
        return null;
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);

        class_2338 controllerBefore = controller;
        int prevSize = width;
        int prevHeight = height;
        int prevLum = luminosity;

        updateConnectivity = view.method_71433("Uninitialized", false);
        luminosity = view.method_71424("Luminosity", 0);

        lastKnownPos = view.method_71426("LastKnownPos", class_2338.field_25064).orElse(null);

        controller = view.method_71426("Controller", class_2338.field_25064).orElse(null);

        if (isController()) {
            window = view.method_71433("Window", false);
            width = view.method_71424("Size", 0);
            height = view.method_71424("Height", 0);
            tankInventory.setCapacity(getTotalTankSize() * getCapacityMultiplier());

            tankInventory.read(view);
        }

        boiler.read(view.method_71434("Boiler"), width * width * height);

        if (view.method_71433("ForceFluidLevel", false) || fluidLevel == null)
            fluidLevel = LerpedFloat.linear().startWithValue(getFillState());

        updateCapability = true;

        if (!clientPacket)
            return;

        boolean changeOfController = !Objects.equals(controllerBefore, controller);
        if (changeOfController || prevSize != width || prevHeight != height) {
            if (method_11002())
                field_11863.method_8413(method_11016(), method_11010(), method_11010(), 16);
            if (isController())
                tankInventory.setCapacity(getCapacityMultiplier() * getTotalTankSize());
            invalidateRenderBoundingBox();
        }
        if (isController()) {
            float fillState = getFillState();
            if (view.method_71433("ForceFluidLevel", false) || fluidLevel == null)
                fluidLevel = LerpedFloat.linear().startWithValue(fillState);
            fluidLevel.chase(fillState, 0.5f, Chaser.EXP);
        }
        if (luminosity != prevLum && method_11002())
            field_11863.method_8398().method_12130().method_15513(field_11867);

        if (view.method_71433("LazySync", false))
            fluidLevel.chase(fluidLevel.getChaseTarget(), 0.125f, Chaser.EXP);
    }

    public float getFillState() {
        return (float) tankInventory.getFluid().getAmount() / tankInventory.getMaxAmountPerStack();
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        if (updateConnectivity)
            view.method_71472("Uninitialized", true);
        boiler.write(view.method_71461("Boiler"));
        if (lastKnownPos != null)
            view.method_71468("LastKnownPos", class_2338.field_25064, lastKnownPos);
        if (!isController())
            view.method_71468("Controller", class_2338.field_25064, controller);
        if (isController()) {
            view.method_71472("Window", window);
            tankInventory.write(view);
            view.method_71465("Size", width);
            view.method_71465("Height", height);
        }
        view.method_71465("Luminosity", luminosity);
        super.write(view, clientPacket);

        if (!clientPacket)
            return;
        if (forceFluidLevelUpdate)
            view.method_71472("ForceFluidLevel", true);
        if (queuedSync)
            view.method_71472("LazySync", true);
        forceFluidLevelUpdate = false;
    }

    @Override
    public void writeSafe(class_11372 view) {
        if (isController()) {
            view.method_71472("Window", window);
            view.method_71465("Size", width);
            view.method_71465("Height", height);
        }
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.STEAM_ENGINE_MAXED, AllAdvancements.PIPE_ORGAN);
    }

    public FluidTank getTankInventory() {
        return tankInventory;
    }

    public int getTotalTankSize() {
        return width * width * height;
    }

    public static int getMaxSize() {
        return MAX_SIZE;
    }

    public static int getCapacityMultiplier() {
        return AllConfigs.server().fluids.fluidTankCapacity.get() * BucketFluidInventory.CAPACITY;
    }

    public static int getMaxHeight() {
        return AllConfigs.server().fluids.fluidTankMaxHeight.get();
    }

    public LerpedFloat getFluidLevel() {
        return fluidLevel;
    }

    public void setFluidLevel(LerpedFloat fluidLevel) {
        this.fluidLevel = fluidLevel;
    }

    @Override
    public void preventConnectivityUpdate() {
        updateConnectivity = false;
    }

    @Override
    public void notifyMultiUpdated() {
        class_2680 state = method_11010();
        if (FluidTankBlock.isTank(state)) { // safety
            state = state.method_11657(FluidTankBlock.BOTTOM, getController().method_10264() == field_11867.method_10264());
            state = state.method_11657(FluidTankBlock.TOP, getController().method_10264() + height - 1 == field_11867.method_10264());
            field_11863.method_8652(field_11867, state, class_2248.field_31028 | class_2248.field_31029);
        }
        if (isController())
            setWindows(window);
        onFluidStackChanged(tankInventory.getFluid());
        updateBoilerState();
        method_5431();
    }

    @Override
    public void setExtraData(@Nullable Object data) {
        if (data instanceof Boolean)
            window = (boolean) data;
    }

    @Override
    @Nullable
    public Object getExtraData() {
        return window;
    }

    @Override
    public Object modifyExtraData(Object data) {
        if (data instanceof Boolean windows) {
            windows |= window;
            return windows;
        }
        return data;
    }

    @Override
    public class_2350.class_2351 getMainConnectionAxis() {
        return class_2350.class_2351.field_11052;
    }

    @Override
    public int getMaxLength(class_2350.class_2351 longAxis, int width) {
        if (longAxis == class_2350.class_2351.field_11052)
            return getMaxHeight();
        return getMaxWidth();
    }

    @Override
    public int getMaxWidth() {
        return MAX_SIZE;
    }

    @Override
    public int getHeight() {
        return height;
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public int getWidth() {
        return width;
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public boolean hasTank() {
        return true;
    }

    @Override
    public int getTankSize(int tank) {
        return getCapacityMultiplier();
    }

    @Override
    public void setTankSize(int tank, int blocks) {
        applyFluidTankSize(blocks);
    }

    @Override
    public FluidTank getTank(int tank) {
        return tankInventory;
    }

    @Override
    public FluidStack getFluid(int tank) {
        return tankInventory.getFluid().copy();
    }

    @Override
    public boolean matches(FluidStack stack, FluidStack otherStack) {
        return tankInventory.matches(stack, otherStack);
    }

    public class FluidTankInventory extends FluidTank {
        public FluidTankInventory(int capacity) {
            super(capacity);
        }

        @Override
        public void markDirty() {
            onFluidStackChanged(fluid);
        }
    }
}
