package com.zurrtum.create.content.kinetics.base;

import com.zurrtum.create.catnip.data.Iterate;
import net.minecraft.class_1750;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2689.class_2690;
import net.minecraft.class_2741;
import net.minecraft.class_2754;

public abstract class HorizontalKineticBlock extends KineticBlock {

    public static final class_2754<class_2350> HORIZONTAL_FACING = class_2741.field_12481;

    public HorizontalKineticBlock(class_2251 properties) {
        super(properties);
    }

    @Override
    protected void method_9515(class_2690<class_2248, class_2680> builder) {
        builder.method_11667(HORIZONTAL_FACING);
        super.method_9515(builder);
    }

    @Override
    public class_2680 method_9605(class_1750 context) {
        return method_9564().method_11657(HORIZONTAL_FACING, context.method_8042().method_10153());
    }

    public class_2350 getPreferredHorizontalFacing(class_1750 context) {
        class_2350 prefferedSide = null;
        for (class_2350 side : Iterate.horizontalDirections) {
            class_2680 blockState = context.method_8045().method_8320(context.method_8037().method_10093(side));
            if (blockState.method_26204() instanceof IRotate) {
                if (((IRotate) blockState.method_26204()).hasShaftTowards(
                    context.method_8045(),
                    context.method_8037().method_10093(side),
                    blockState,
                    side.method_10153()
                ))
                    if (prefferedSide != null && prefferedSide.method_10166() != side.method_10166()) {
                        prefferedSide = null;
                        break;
                    } else {
                        prefferedSide = side;
                    }
            }
        }
        return prefferedSide;
    }

    @Override
    public class_2680 method_9598(class_2680 state, class_2470 rot) {
        return state.method_11657(HORIZONTAL_FACING, rot.method_10503(state.method_11654(HORIZONTAL_FACING)));
    }

    @Override
    @SuppressWarnings("deprecation")
    public class_2680 method_9569(class_2680 state, class_2415 mirrorIn) {
        return state.method_26186(mirrorIn.method_10345(state.method_11654(HORIZONTAL_FACING)));
    }

}
