package com.zurrtum.create.content.kinetics.base;

import com.zurrtum.create.foundation.advancement.AdvancementBehaviour;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_4538;
import net.minecraft.class_4970;

public abstract class KineticBlock extends class_2248 implements IRotate {

    public KineticBlock(class_4970.class_2251 properties) {
        super(properties);
    }

    @Override
    public void method_9615(class_2680 state, class_1937 worldIn, class_2338 pos, class_2680 oldState, boolean isMoving) {
        // onBlockAdded is useless for init, as sometimes the BE gets re-instantiated

        // however, if a block change occurs that does not change kinetic connections,
        // we can prevent a major re-propagation here

        class_2586 blockEntity = worldIn.method_8321(pos);
        if (blockEntity instanceof KineticBlockEntity kineticBlockEntity) {
            kineticBlockEntity.preventSpeedUpdate = 0;

            if (oldState.method_26204() != state.method_26204())
                return;
            if (state.method_31709() != oldState.method_31709())
                return;
            if (!areStatesKineticallyEquivalent(oldState, state))
                return;

            kineticBlockEntity.preventSpeedUpdate = 2;
        }
    }

    @Override
    public boolean hasShaftTowards(class_4538 world, class_2338 pos, class_2680 state, class_2350 face) {
        return false;
    }

    protected boolean areStatesKineticallyEquivalent(class_2680 oldState, class_2680 newState) {
        if (oldState.method_26204() != newState.method_26204())
            return false;
        return getRotationAxis(newState) == getRotationAxis(oldState);
    }

    @Override
    public void method_9517(class_2680 stateIn, class_1936 worldIn, class_2338 pos, int flags, int count) {
        if (worldIn.method_8608())
            return;

        class_2586 blockEntity = worldIn.method_8321(pos);
        if (!(blockEntity instanceof KineticBlockEntity kbe))
            return;

        if (kbe.preventSpeedUpdate > 0)
            return;

        // Remove previous information when block is added
        kbe.warnOfMovement();
        kbe.clearKineticInformation();
        kbe.updateSpeed = true;
    }

    @Override
    public void method_9567(class_1937 worldIn, class_2338 pos, class_2680 state, class_1309 placer, class_1799 stack) {
        AdvancementBehaviour.setPlacedBy(worldIn, pos, placer);
        if (worldIn.method_8608())
            return;

        class_2586 blockEntity = worldIn.method_8321(pos);
        if (!(blockEntity instanceof KineticBlockEntity kbe))
            return;

        kbe.effects.queueRotationIndicators();
    }

    public float getParticleTargetRadius() {
        return .65f;
    }

    public float getParticleInitialRadius() {
        return .75f;
    }

}