package com.zurrtum.create.content.kinetics.belt;

import com.zurrtum.create.AllItemTags;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.foundation.fluid.FluidHelper;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4013;

public class BeltHelper {

    public static Map<class_1792, Boolean> uprightCache = new Object2BooleanOpenHashMap<>();
    public static final class_4013 LISTENER = resourceManager -> uprightCache.clear();

    public static boolean isItemUpright(class_1799 stack) {
        return uprightCache.computeIfAbsent(
            stack.method_7909(),
            item -> (FluidHelper.hasFluidInventory(stack) || stack.method_31573(AllItemTags.UPRIGHT_ON_BELT)) && !stack.method_31573(AllItemTags.NOT_UPRIGHT_ON_BELT)
        );
    }

    public static BeltBlockEntity getSegmentBE(class_1936 world, class_2338 pos) {
        if (world instanceof class_1937 l && !l.method_8477(pos))
            return null;
        class_2586 blockEntity = world.method_8321(pos);
        if (!(blockEntity instanceof BeltBlockEntity))
            return null;
        return (BeltBlockEntity) blockEntity;
    }

    public static BeltBlockEntity getControllerBE(class_1936 world, class_2338 pos) {
        BeltBlockEntity segment = getSegmentBE(world, pos);
        if (segment == null)
            return null;
        class_2338 controllerPos = segment.controller;
        if (controllerPos == null)
            return null;
        return getSegmentBE(world, controllerPos);
    }

    public static BeltBlockEntity getBeltForOffset(BeltBlockEntity controller, float offset) {
        return getBeltAtSegment(controller, (int) Math.floor(offset));
    }

    public static BeltBlockEntity getBeltAtSegment(BeltBlockEntity controller, int segment) {
        class_2338 pos = getPositionForOffset(controller, segment);
        class_2586 be = controller.method_10997().method_8321(pos);
        if (be == null || !(be instanceof BeltBlockEntity))
            return null;
        return (BeltBlockEntity) be;
    }

    public static class_2338 getPositionForOffset(BeltBlockEntity controller, int offset) {
        class_2338 pos = controller.method_11016();
        class_2382 vec = controller.getBeltFacing().method_62675();
        BeltSlope slope = controller.method_11010().method_11654(BeltBlock.SLOPE);
        int verticality = slope == BeltSlope.DOWNWARD ? -1 : slope == BeltSlope.UPWARD ? 1 : 0;

        return pos.method_10069(offset * vec.method_10263(), class_3532.method_15340(offset, 0, controller.beltLength - 1) * verticality, offset * vec.method_10260());
    }

    public static class_243 getVectorForOffset(BeltBlockEntity controller, float offset) {
        BeltSlope slope = controller.method_11010().method_11654(BeltBlock.SLOPE);
        float verticalMovement = slope == BeltSlope.DOWNWARD ? -1 : slope == BeltSlope.UPWARD ? 1 : 0;
        if (offset < .5)
            verticalMovement = 0;
        verticalMovement = verticalMovement * (Math.min(offset, controller.beltLength - .5f) - .5f);
        class_243 vec = VecHelper.getCenterOf(controller.method_11016());
        class_243 horizontalMovement = class_243.method_24954(controller.getBeltFacing().method_62675()).method_1021(offset - .5f);

        if (slope == BeltSlope.VERTICAL)
            horizontalMovement = class_243.field_1353;

        vec = vec.method_1019(horizontalMovement).method_1031(0, verticalMovement, 0);
        return vec;
    }

    public static class_243 getVectorForOffset(class_2338 pos, BeltSlope slope, int verticality, int beltLength, class_2382 directionVec, float offset) {
        float verticalMovement = verticality;
        if (offset < .5)
            verticalMovement = 0;
        verticalMovement = verticalMovement * (Math.min(offset, beltLength - .5f) - .5f);
        class_243 vec = VecHelper.getCenterOf(pos);
        class_243 horizontalMovement = class_243.method_24954(directionVec).method_1021(offset - .5f);

        if (slope == BeltSlope.VERTICAL)
            horizontalMovement = class_243.field_1353;

        vec = vec.method_1019(horizontalMovement).method_1031(0, verticalMovement, 0);
        return vec;
    }

    public static class_243 getBeltVector(class_2680 state) {
        BeltSlope slope = state.method_11654(BeltBlock.SLOPE);
        int verticality = slope == BeltSlope.DOWNWARD ? -1 : slope == BeltSlope.UPWARD ? 1 : 0;
        class_243 horizontalMovement = class_243.method_24954(state.method_11654(BeltBlock.HORIZONTAL_FACING).method_62675());
        if (slope == BeltSlope.VERTICAL)
            return new class_243(0, state.method_11654(BeltBlock.HORIZONTAL_FACING).method_10171().method_10181(), 0);
        return new class_243(0, verticality, 0).method_1019(horizontalMovement);
    }

}
