package com.zurrtum.create.content.kinetics.belt.behaviour;

import com.google.common.collect.ImmutableList;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.kinetics.belt.transport.TransportedItemStack;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BehaviourType;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1799;
import net.minecraft.class_243;

public class TransportedItemStackHandlerBehaviour extends BlockEntityBehaviour<SmartBlockEntity> {

    public static final BehaviourType<TransportedItemStackHandlerBehaviour> TYPE = new BehaviourType<>();

    private ProcessingCallback processingCallback;
    private PositionGetter positionGetter;

    public static class TransportedResult {
        List<TransportedItemStack> outputs;
        TransportedItemStack heldOutput;

        private static final TransportedResult DO_NOTHING = new TransportedResult(null, null);
        private static final TransportedResult REMOVE_ITEM = new TransportedResult(ImmutableList.of(), null);

        public static TransportedResult doNothing() {
            return DO_NOTHING;
        }

        public static TransportedResult removeItem() {
            return REMOVE_ITEM;
        }

        public static TransportedResult convertTo(TransportedItemStack output) {
            return new TransportedResult(ImmutableList.of(output), null);
        }

        public static TransportedResult convertTo(List<TransportedItemStack> outputs) {
            return new TransportedResult(outputs, null);
        }

        public static TransportedResult convertToAndLeaveHeld(List<TransportedItemStack> outputs, TransportedItemStack heldOutput) {
            return new TransportedResult(outputs, heldOutput);
        }

        private TransportedResult(List<TransportedItemStack> outputs, TransportedItemStack heldOutput) {
            this.outputs = outputs;
            this.heldOutput = heldOutput;
        }

        public boolean doesNothing() {
            return outputs == null;
        }

        public boolean didntChangeFrom(class_1799 stackBefore) {
            return doesNothing() || outputs.size() == 1 && class_1799.method_7973(outputs.get(0).stack, stackBefore) && !hasHeldOutput();
        }

        public List<TransportedItemStack> getOutputs() {
            if (outputs == null)
                throw new IllegalStateException("Do not call getOutputs() on a Result that doesNothing().");
            return outputs;
        }

        public boolean hasHeldOutput() {
            return heldOutput != null;
        }

        @Nullable
        public TransportedItemStack getHeldOutput() {
            if (heldOutput == null)
                throw new IllegalStateException("Do not call getHeldOutput() on a Result with hasHeldOutput() == false.");
            return heldOutput;
        }

    }

    public TransportedItemStackHandlerBehaviour(SmartBlockEntity be, ProcessingCallback processingCallback) {
        super(be);
        this.processingCallback = processingCallback;
        positionGetter = t -> VecHelper.getCenterOf(be.method_11016());
    }

    public TransportedItemStackHandlerBehaviour withStackPlacement(PositionGetter function) {
        this.positionGetter = function;
        return this;
    }

    public void handleProcessingOnAllItems(Function<TransportedItemStack, TransportedResult> processFunction) {
        handleCenteredProcessingOnAllItems(.51f, processFunction);
    }

    public void handleProcessingOnItem(TransportedItemStack item, TransportedResult processOutput) {
        handleCenteredProcessingOnAllItems(
            .51f, t -> {
                if (t == item)
                    return processOutput;
                return null;
            }
        );
    }

    public void handleCenteredProcessingOnAllItems(float maxDistanceFromCenter, Function<TransportedItemStack, TransportedResult> processFunction) {
        this.processingCallback.applyToAllItems(maxDistanceFromCenter, processFunction);
    }

    public class_243 getWorldPositionOf(TransportedItemStack transported) {
        return positionGetter.getWorldPositionVector(transported);
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

    @FunctionalInterface
    public interface ProcessingCallback {
        void applyToAllItems(float maxDistanceFromCenter, Function<TransportedItemStack, TransportedResult> processFunction);
    }

    @FunctionalInterface
    public interface PositionGetter {
        class_243 getWorldPositionVector(TransportedItemStack transported);
    }

}
