package com.zurrtum.create.content.kinetics.belt.transport;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.api.registry.CreateRegistries;
import com.zurrtum.create.content.kinetics.belt.BeltHelper;
import com.zurrtum.create.content.kinetics.fan.processing.FanProcessingType;
import com.zurrtum.create.content.logistics.box.PackageItem;
import java.util.Optional;
import java.util.Random;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_7225;

public class TransportedItemStack implements Comparable<TransportedItemStack> {
    public static final Codec<TransportedItemStack> CODEC = RecordCodecBuilder.create(instance -> instance.group(
        class_1799.field_49266.fieldOf("Item").forGetter(i -> i.stack),
        Codec.FLOAT.fieldOf("Pos").forGetter(i -> i.beltPosition),
        Codec.FLOAT.fieldOf("PrevPos").forGetter(i -> i.prevBeltPosition),
        Codec.FLOAT.fieldOf("Offset").forGetter(i -> i.sideOffset),
        Codec.FLOAT.fieldOf("PrevOffset").forGetter(i -> i.prevSideOffset),
        Codec.INT.fieldOf("InSegment").forGetter(i -> i.insertedAt),
        Codec.INT.fieldOf("Angle").forGetter(i -> i.angle),
        class_2350.field_29502.fieldOf("InDirection").forGetter(i -> i.insertedFrom),
        CreateRegistries.FAN_PROCESSING_TYPE.method_39673().optionalFieldOf("FanProcessingType").forGetter(i -> Optional.ofNullable(i.processedBy)),
        Codec.INT.optionalFieldOf("FanProcessingTime", 0).forGetter(i -> i.processingTime),
        Codec.BOOL.fieldOf("Locked").forGetter(i -> i.locked),
        Codec.BOOL.fieldOf("LockedExternally").forGetter(i -> i.lockedExternally)
    ).apply(instance, TransportedItemStack::new));

    private static final Random R = new Random();

    public class_1799 stack;
    public float beltPosition;
    public float sideOffset;
    public int angle;
    public int insertedAt;
    public class_2350 insertedFrom;
    public boolean locked;
    public boolean lockedExternally;

    public float prevBeltPosition;
    public float prevSideOffset;

    public FanProcessingType processedBy;
    public int processingTime;

    public TransportedItemStack(class_1799 stack) {
        this.stack = stack;
        if (PackageItem.isPackage(stack)) {
            angle = R.nextInt(4) * 90 + R.nextInt(20) - 10;
        } else {
            boolean centered = BeltHelper.isItemUpright(stack);
            angle = centered ? 180 : R.nextInt(360);
        }
        sideOffset = prevSideOffset = getTargetSideOffset();
        insertedFrom = class_2350.field_11036;
    }

    @SuppressWarnings("OptionalUsedAsFieldOrParameterType")
    private TransportedItemStack(
        class_1799 stack,
        float beltPosition,
        float prevBeltPosition,
        float sideOffset,
        float prevSideOffset,
        int insertedAt,
        int angle,
        class_2350 insertedFrom,
        Optional<FanProcessingType> processedBy,
        int processingTime,
        boolean locked,
        boolean lockedExternally
    ) {
        this.stack = stack;
        this.beltPosition = beltPosition;
        this.prevBeltPosition = prevBeltPosition;
        this.sideOffset = sideOffset;
        this.prevSideOffset = prevSideOffset;
        this.insertedAt = insertedAt;
        this.angle = angle;
        this.insertedFrom = insertedFrom;
        this.locked = locked;
        this.lockedExternally = lockedExternally;
        this.processedBy = processedBy.orElse(null);
        this.processingTime = processingTime;
    }

    public float getTargetSideOffset() {
        return (angle - 180) / (360 * 3f);
    }

    @Override
    public int compareTo(TransportedItemStack o) {
        return beltPosition < o.beltPosition ? 1 : beltPosition > o.beltPosition ? -1 : 0;
    }

    public TransportedItemStack getSimilar() {
        TransportedItemStack copy = new TransportedItemStack(stack.method_7972());
        copy.beltPosition = beltPosition;
        copy.insertedAt = insertedAt;
        copy.insertedFrom = insertedFrom;
        copy.prevBeltPosition = prevBeltPosition;
        copy.prevSideOffset = prevSideOffset;
        copy.processedBy = processedBy;
        copy.processingTime = processingTime;
        return copy;
    }

    public TransportedItemStack copy() {
        TransportedItemStack copy = getSimilar();
        copy.angle = angle;
        copy.sideOffset = sideOffset;
        return copy;
    }

    public class_2487 serializeNBT(class_7225.class_7874 registries) {
        class_2487 nbt = new class_2487();
        if (!stack.method_7960()) {
            nbt.method_67494("Item", class_1799.field_24671, stack);
        }
        nbt.method_10548("Pos", beltPosition);
        nbt.method_10548("PrevPos", prevBeltPosition);
        nbt.method_10548("Offset", sideOffset);
        nbt.method_10548("PrevOffset", prevSideOffset);
        nbt.method_10569("InSegment", insertedAt);
        nbt.method_10569("Angle", angle);
        nbt.method_10569("InDirection", insertedFrom.method_10146());

        if (processedBy != null) {
            class_2960 key = CreateRegistries.FAN_PROCESSING_TYPE.method_10221(processedBy);
            if (key == null)
                throw new IllegalArgumentException("Could not get id for FanProcessingType " + processedBy + "!");

            nbt.method_10582("FanProcessingType", key.toString());
            nbt.method_10569("FanProcessingTime", processingTime);
        }

        if (locked)
            nbt.method_10556("Locked", locked);
        if (lockedExternally)
            nbt.method_10556("LockedExternally", lockedExternally);
        return nbt;
    }

    public static TransportedItemStack read(class_2487 nbt, class_7225.class_7874 registries) {
        class_1799 source = nbt.method_67491("Item", class_1799.field_24671).orElse(class_1799.field_8037);
        TransportedItemStack stack = new TransportedItemStack(source);
        stack.beltPosition = nbt.method_66563("Pos", 0);
        stack.prevBeltPosition = nbt.method_66563("PrevPos", 0);
        stack.sideOffset = nbt.method_66563("Offset", 0);
        stack.prevSideOffset = nbt.method_66563("PrevOffset", 0);
        stack.insertedAt = nbt.method_68083("InSegment", 0);
        stack.angle = nbt.method_68083("Angle", 0);
        stack.insertedFrom = class_2350.method_10143(nbt.method_68083("InDirection", 0));
        stack.locked = nbt.method_68566("Locked", false);
        stack.lockedExternally = nbt.method_68566("LockedExternally", false);

        if (nbt.method_10545("FanProcessingType")) {
            stack.processedBy = FanProcessingType.parse(nbt.method_68564("FanProcessingType", ""));
            stack.processingTime = nbt.method_68083("FanProcessingTime", 0);
        }

        return stack;
    }

    public void clearFanProcessingData() {
        processedBy = null;
        processingTime = 0;
    }

}
