package com.zurrtum.create.content.kinetics.clock;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.content.kinetics.base.HorizontalKineticBlock;
import com.zurrtum.create.foundation.block.IBE;
import net.minecraft.class_10;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3726;
import net.minecraft.class_4538;

public class CuckooClockBlock extends HorizontalKineticBlock implements IBE<CuckooClockBlockEntity> {

    private final boolean mysterious;

    public static CuckooClockBlock regular(class_2251 properties) {
        return new CuckooClockBlock(false, properties);
    }

    public static CuckooClockBlock mysterious(class_2251 properties) {
        return new CuckooClockBlock(true, properties);
    }

    protected CuckooClockBlock(boolean mysterious, class_2251 properties) {
        super(properties);
        this.mysterious = mysterious;
    }

    @Override
    public class_265 method_9530(class_2680 p_220053_1_, class_1922 p_220053_2_, class_2338 p_220053_3_, class_3726 p_220053_4_) {
        return AllShapes.CUCKOO_CLOCK;
    }

    @Override
    public class_2680 method_9605(class_1750 context) {
        class_2350 preferred = getPreferredHorizontalFacing(context);
        if (preferred != null)
            return method_9564().method_11657(HORIZONTAL_FACING, preferred.method_10153());
        return method_9564().method_11657(HORIZONTAL_FACING, context.method_8042().method_10153());
    }

    @Override
    public boolean hasShaftTowards(class_4538 world, class_2338 pos, class_2680 state, class_2350 face) {
        return face == state.method_11654(HORIZONTAL_FACING).method_10153();
    }

    public static boolean containsSurprise(class_2680 state) {
        class_2248 block = state.method_26204();
        return block instanceof CuckooClockBlock && ((CuckooClockBlock) block).mysterious;
    }

    @Override
    public class_2351 getRotationAxis(class_2680 state) {
        return state.method_11654(HORIZONTAL_FACING).method_10166();
    }

    @Override
    protected boolean method_9516(class_2680 state, class_10 pathComputationType) {
        return false;
    }

    @Override
    public Class<CuckooClockBlockEntity> getBlockEntityClass() {
        return CuckooClockBlockEntity.class;
    }

    @Override
    public class_2591<? extends CuckooClockBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.CUCKOO_CLOCK;
    }

}
