package com.zurrtum.create.content.kinetics.deployer;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.content.equipment.sandPaper.SandPaperPolishingRecipe;
import com.zurrtum.create.content.kinetics.belt.BeltHelper;
import com.zurrtum.create.content.kinetics.belt.behaviour.BeltProcessingBehaviour.ProcessingResult;
import com.zurrtum.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.zurrtum.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour.TransportedResult;
import com.zurrtum.create.content.kinetics.belt.transport.TransportedItemStack;
import com.zurrtum.create.content.kinetics.deployer.DeployerBlockEntity.Mode;
import com.zurrtum.create.content.kinetics.deployer.DeployerBlockEntity.State;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1304;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_9696;

import static com.zurrtum.create.content.kinetics.base.DirectionalKineticBlock.FACING;

public class BeltDeployerCallbacks {

    public static ProcessingResult onItemReceived(TransportedItemStack s, TransportedItemStackHandlerBehaviour i, DeployerBlockEntity blockEntity) {

        if (blockEntity.getSpeed() == 0)
            return ProcessingResult.PASS;
        if (blockEntity.mode == Mode.PUNCH)
            return ProcessingResult.PASS;
        class_2680 blockState = blockEntity.method_11010();
        if (!blockState.method_28498(FACING) || blockState.method_11654(FACING) != class_2350.field_11033)
            return ProcessingResult.PASS;
        if (blockEntity.state != State.WAITING)
            return ProcessingResult.HOLD;
        if (blockEntity.redstoneLocked)
            return ProcessingResult.PASS;

        DeployerPlayer player = blockEntity.getPlayer();
        class_1799 held = player == null ? class_1799.field_8037 : player.cast().method_6047();

        if (held.method_7960())
            return ProcessingResult.HOLD;
        if (blockEntity.getRecipe(s.stack) == null)
            return ProcessingResult.PASS;

        blockEntity.start();
        return ProcessingResult.HOLD;
    }

    public static ProcessingResult whenItemHeld(TransportedItemStack s, TransportedItemStackHandlerBehaviour i, DeployerBlockEntity blockEntity) {

        if (blockEntity.getSpeed() == 0)
            return ProcessingResult.PASS;
        class_2680 blockState = blockEntity.method_11010();
        if (!blockState.method_28498(FACING) || blockState.method_11654(FACING) != class_2350.field_11033)
            return ProcessingResult.PASS;

        DeployerPlayer player = blockEntity.getPlayer();
        class_1799 held = player == null ? class_1799.field_8037 : player.cast().method_6047();
        if (held.method_7960())
            return ProcessingResult.HOLD;

        class_1860<?> recipe = blockEntity.getRecipe(s.stack);
        if (recipe == null)
            return ProcessingResult.PASS;

        if (blockEntity.state == State.RETRACTING && blockEntity.timer == 1000) {
            activate(s, i, blockEntity, recipe);
            return ProcessingResult.HOLD;
        }

        if (blockEntity.state == State.WAITING) {
            if (blockEntity.redstoneLocked)
                return ProcessingResult.PASS;
            blockEntity.start();
        }

        return ProcessingResult.HOLD;
    }

    public static void activate(
        TransportedItemStack transported,
        TransportedItemStackHandlerBehaviour handler,
        DeployerBlockEntity blockEntity,
        class_1860<?> recipe
    ) {
        class_1937 world = blockEntity.method_10997();
        TransportedItemStack result = null;
        class_1799 resultItem = null;
        boolean keepHeld = false;
        class_3222 player = blockEntity.player.cast();
        class_1799 heldItem = player.method_6047();
        if (recipe instanceof SandPaperPolishingRecipe polishingRecipe) {
            resultItem = polishingRecipe.craft(new class_9696(transported.stack), world.method_30349());
        } else if (recipe instanceof ItemApplicationRecipe itemApplicationRecipe) {
            resultItem = itemApplicationRecipe.craft(new ItemApplicationInput(transported.stack, heldItem), world.method_30349());
            keepHeld = itemApplicationRecipe.keepHeldItem();
        }
        if (resultItem != null && !resultItem.method_7960()) {
            result = transported.copy();
            boolean centered = BeltHelper.isItemUpright(resultItem);
            result.stack = resultItem;
            result.locked = true;
            result.angle = centered ? 180 : world.field_9229.method_43048(360);
            result.locked = false;
        }

        blockEntity.award(AllAdvancements.DEPLOYER);

        transported.clearFanProcessingData();

        TransportedItemStack left = transported.copy();
        blockEntity.player.setSpawnedItemEffects(transported.stack.method_7972());
        left.stack.method_7934(1);

        if (result == null) {
            resultItem = left.stack.method_7972();
            handler.handleProcessingOnItem(transported, TransportedResult.convertTo(left));
        } else {
            handler.handleProcessingOnItem(transported, TransportedResult.convertToAndLeaveHeld(List.of(result), left));
        }

        if (!keepHeld) {
            if (heldItem.method_7936() > 0) {
                heldItem.method_7970(1, player, class_1304.field_6173);
            } else {
                class_1799 leftover = heldItem.method_7909().method_7858();
                heldItem.method_7934(1);
                if (!leftover.method_7960()) {
                    if (heldItem.method_7960()) {
                        player.method_6122(class_1268.field_5808, leftover);
                    } else if (!player.method_31548().method_7394(leftover)) {
                        player.method_7328(leftover, false);
                    }
                }
            }
        }

        if (!resultItem.method_7960())
            awardAdvancements(blockEntity, resultItem);

        class_2338 pos = blockEntity.method_11016();
        if (heldItem.method_7960())
            world.method_8396(null, pos, class_3417.field_15075.comp_349(), class_3419.field_15245, .25f, 1);
        world.method_8396(null, pos, class_3417.field_15197, class_3419.field_15245, .25f, .75f);
        if (recipe instanceof SandPaperPolishingRecipe)
            AllSoundEvents.SANDING_SHORT.playOnServer(world, pos, .35f, 1f);

        blockEntity.notifyUpdate();
    }

    private static void awardAdvancements(DeployerBlockEntity blockEntity, class_1799 created) {
        CreateTrigger advancement;

        if (created.method_31574(AllItems.ANDESITE_CASING))
            advancement = AllAdvancements.ANDESITE_CASING;
        else if (created.method_31574(AllItems.BRASS_CASING))
            advancement = AllAdvancements.BRASS_CASING;
        else if (created.method_31574(AllItems.COPPER_CASING))
            advancement = AllAdvancements.COPPER_CASING;
        else if (created.method_31574(AllItems.RAILWAY_CASING))
            advancement = AllAdvancements.TRAIN_CASING;
        else
            return;

        blockEntity.award(advancement);
    }

}
