package com.zurrtum.create.content.kinetics.drill;

import com.zurrtum.create.AllBlockTags;
import com.zurrtum.create.AllDamageSources;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import com.zurrtum.create.content.kinetics.base.BlockBreakingMovementBehaviour;
import net.minecraft.class_1282;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;

public class DrillMovementBehaviour extends BlockBreakingMovementBehaviour {
    @Override
    public boolean isActive(MovementContext context) {
        return super.isActive(context) && !VecHelper.isVecPointingTowards(context.relativeMotion, context.state.method_11654(DrillBlock.FACING).method_10153());
    }

    @Override
    public class_243 getActiveAreaOffset(MovementContext context) {
        return class_243.method_24954(context.state.method_11654(DrillBlock.FACING).method_62675()).method_1021(.65f);
    }

    @Override
    public boolean disableBlockEntityRendering() {
        return true;
    }

    @Override
    protected class_1282 getDamageSource(class_1937 level) {
        return AllDamageSources.get(level).drill;
    }

    @Override
    public boolean canBreak(class_1937 world, class_2338 breakingPos, class_2680 state) {
        return super.canBreak(world, breakingPos, state) && !state.method_26220(world, breakingPos)
            .method_1110() && !state.method_26164(AllBlockTags.TRACKS);
    }
}
