package com.zurrtum.create.content.kinetics.fan.processing;

import com.zurrtum.create.api.registry.CreateRegistries;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_5819;

public interface FanProcessingType {
    @Nullable
    static FanProcessingType parse(String str) {
        return CreateRegistries.FAN_PROCESSING_TYPE.method_63535(class_2960.method_12829(str));
    }

    @Nullable
    static FanProcessingType getAt(class_1937 level, class_2338 pos) {
        for (FanProcessingType type : FanProcessingTypeRegistry.SORTED_TYPES_VIEW) {
            if (type.isValidAt(level, pos)) {
                return type;
            }
        }
        return null;
    }

    boolean isValidAt(class_1937 level, class_2338 pos);

    int getPriority();

    boolean canProcess(class_1799 stack, class_1937 level);

    @Nullable List<class_1799> process(class_1799 stack, class_1937 level);

    void spawnProcessingParticles(class_1937 level, class_243 pos);

    void morphAirFlow(AirFlowParticleAccess particleAccess, class_5819 random);

    void affectEntity(class_1297 entity, class_1937 level);

    interface AirFlowParticleAccess {
        void setColor(int color);

        void setAlpha(float alpha);

        void spawnExtraParticle(class_2394 options, float speedMultiplier);
    }
}
