package com.zurrtum.create.content.kinetics.mechanicalArm;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_243;
import net.minecraft.class_3532;

public class ArmAngleTarget {

    static final ArmAngleTarget NO_TARGET = new ArmAngleTarget();

    float baseAngle;
    float lowerArmAngle;
    float upperArmAngle;
    float headAngle;

    private ArmAngleTarget() {
        lowerArmAngle = 135;
        upperArmAngle = 45;
        headAngle = 0;
    }

    public ArmAngleTarget(class_2338 armPos, class_243 pointTarget, class_2350 clawFacing, boolean ceiling) {
        class_243 target = pointTarget;
        class_243 origin = VecHelper.getCenterOf(armPos).method_1031(0, ceiling ? -6 / 16f : 6 / 16f, 0);
        class_243 clawTarget = target;
        target = target.method_1019(class_243.method_24954(clawFacing.method_10153().method_62675()).method_1021(.5f));

        class_243 diff = target.method_1020(origin);
        float horizontalDistance = (float) diff.method_18805(1, 0, 1).method_1033();

        float baseAngle = AngleHelper.deg(class_3532.method_15349(diff.field_1352, diff.field_1350)) + 180;
        if (ceiling) {
            diff = diff.method_18805(1, -1, 1);
            baseAngle = 180 - baseAngle;
        }

        float alphaOffset = AngleHelper.deg(class_3532.method_15349(diff.field_1351, horizontalDistance));

        float a = 14 / 16f; // lower arm length
        float a2 = a * a;
        float b = 15 / 16f; // upper arm length
        float b2 = b * b;
        float diffLength = class_3532.method_15363(class_3532.method_15355((float) (diff.field_1351 * diff.field_1351 + horizontalDistance * horizontalDistance)), 1 / 8f, a + b);
        float diffLength2 = diffLength * diffLength;

        float alphaRatio = (-b2 + a2 + diffLength2) / (2 * a * diffLength);
        float alpha = AngleHelper.deg(Math.acos(alphaRatio)) + alphaOffset;
        float betaRatio = (-diffLength2 + a2 + b2) / (2 * b * a);
        float beta = AngleHelper.deg(Math.acos(betaRatio));

        if (Float.isNaN(alpha))
            alpha = 0;
        if (Float.isNaN(beta))
            beta = 0;

        class_243 headPos = new class_243(0, 0, 0);
        headPos = VecHelper.rotate(headPos.method_1031(0, b, 0), beta + 180, class_2351.field_11048);
        headPos = VecHelper.rotate(headPos.method_1031(0, a, 0), alpha - 90, class_2351.field_11048);
        headPos = VecHelper.rotate(headPos, baseAngle, class_2351.field_11052);
        headPos = VecHelper.rotate(headPos, ceiling ? 180 : 0, class_2351.field_11048);
        headPos = headPos.method_1019(origin);
        class_243 headDiff = clawTarget.method_1020(headPos);

        if (ceiling)
            headDiff = headDiff.method_18805(1, -1, 1);

        float horizontalHeadDistance = (float) headDiff.method_18805(1, 0, 1).method_1033();
        float headAngle = (float) (alpha + beta + 135 - AngleHelper.deg(class_3532.method_15349(headDiff.field_1351, horizontalHeadDistance)));

        this.lowerArmAngle = alpha;
        this.upperArmAngle = beta;
        this.headAngle = -headAngle;
        this.baseAngle = baseAngle;
    }

}
