package com.zurrtum.create.content.kinetics.simpleRelays;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.content.decoration.encasing.EncasableBlock;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.content.kinetics.speedController.SpeedControllerBlock;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2350.class_2352;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_3222;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;

public class CogWheelBlock extends AbstractSimpleShaftBlock implements ICogWheel, EncasableBlock {
    boolean isLarge;

    public CogWheelBlock(boolean large, class_2251 settings) {
        super(settings);
        isLarge = large;
        method_9590(method_9564().method_11657(AXIS, class_2350.class_2351.field_11052));
    }

    public static CogWheelBlock small(class_2251 settings) {
        return new CogWheelBlock(false, settings);
    }

    public static CogWheelBlock large(class_2251 settings) {
        return new CogWheelBlock(true, settings);
    }

    @Override
    public boolean isLargeCog() {
        return isLarge;
    }

    @Override
    public boolean isSmallCog() {
        return !isLarge;
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return (isLarge ? AllShapes.LARGE_GEAR : AllShapes.SMALL_GEAR).get(state.method_11654(AXIS));
    }

    @Override
    public boolean method_9558(class_2680 state, class_4538 worldIn, class_2338 pos) {
        return isValidCogwheelPosition(ICogWheel.isLargeCog(state), worldIn, pos, state.method_11654(AXIS));
    }

    @Override
    public void method_9567(class_1937 worldIn, class_2338 pos, class_2680 state, class_1309 placer, class_1799 stack) {
        super.method_9567(worldIn, pos, state, placer, stack);
        if (placer instanceof class_1657 player)
            triggerShiftingGearsAdvancement(worldIn, pos, state, player);
    }

    protected void triggerShiftingGearsAdvancement(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        if (world.method_8608() || player == null)
            return;

        class_2351 axis = state.method_11654(CogWheelBlock.AXIS);
        for (class_2351 perpendicular1 : Iterate.axes) {
            if (perpendicular1 == axis)
                continue;

            class_2350 d1 = class_2350.method_10156(class_2352.field_11056, perpendicular1);
            for (class_2351 perpendicular2 : Iterate.axes) {
                if (perpendicular1 == perpendicular2)
                    continue;
                if (axis == perpendicular2)
                    continue;

                class_2350 d2 = class_2350.method_10156(class_2352.field_11056, perpendicular2);
                for (int offset1 : Iterate.positiveAndNegative) {
                    for (int offset2 : Iterate.positiveAndNegative) {
                        class_2338 connectedPos = pos.method_10079(d1, offset1).method_10079(d2, offset2);
                        class_2680 blockState = world.method_8320(connectedPos);
                        if (!(blockState.method_26204() instanceof CogWheelBlock))
                            continue;
                        if (blockState.method_11654(CogWheelBlock.AXIS) != axis)
                            continue;
                        if (ICogWheel.isLargeCog(blockState) == isLarge)
                            continue;

                        AllAdvancements.COGS.trigger((class_3222) player);
                    }
                }
            }
        }
    }

    @Override
    protected class_1269 method_55765(
        class_1799 stack,
        class_2680 state,
        class_1937 level,
        class_2338 pos,
        class_1657 player,
        class_1268 hand,
        class_3965 hitResult
    ) {
        if (player.method_5715() || !player.method_7294())
            return class_1269.field_52423;

        class_1269 result = tryEncase(state, level, pos, stack, player, hand, hitResult);
        if (result.method_23665())
            return result;

        return class_1269.field_52423;
    }

    public static boolean isValidCogwheelPosition(boolean large, class_4538 worldIn, class_2338 pos, class_2351 cogAxis) {
        for (class_2350 facing : Iterate.directions) {
            if (facing.method_10166() == cogAxis)
                continue;

            class_2338 offsetPos = pos.method_10093(facing);
            class_2680 blockState = worldIn.method_8320(offsetPos);
            if (blockState.method_28498(AXIS) && facing.method_10166() == blockState.method_11654(AXIS))
                continue;

            if (ICogWheel.isLargeCog(blockState) || large && ICogWheel.isSmallCog(blockState))
                return false;
        }
        return true;
    }

    protected class_2351 getAxisForPlacement(class_1750 context) {
        if (context.method_8036() != null && context.method_8036().method_5715())
            return context.method_8038().method_10166();

        class_1937 world = context.method_8045();
        class_2680 stateBelow = world.method_8320(context.method_8037().method_10074());

        if (stateBelow.method_27852(AllBlocks.ROTATION_SPEED_CONTROLLER) && isLargeCog())
            return stateBelow.method_11654(SpeedControllerBlock.HORIZONTAL_AXIS) == class_2351.field_11048 ? class_2351.field_11051 : class_2351.field_11048;

        class_2338 placedOnPos = context.method_8037().method_10093(context.method_8038().method_10153());
        class_2680 placedAgainst = world.method_8320(placedOnPos);

        class_2248 block = placedAgainst.method_26204();
        if (ICogWheel.isSmallCog(placedAgainst))
            return ((IRotate) block).getRotationAxis(placedAgainst);

        class_2351 preferredAxis = getPreferredAxis(context);
        return preferredAxis != null ? preferredAxis : context.method_8038().method_10166();
    }

    @Override
    public class_2680 method_9605(class_1750 context) {
        boolean shouldWaterlog = context.method_8045().method_8316(context.method_8037()).method_15772() == class_3612.field_15910;
        return this.method_9564().method_11657(AXIS, getAxisForPlacement(context)).method_11657(class_2741.field_12508, shouldWaterlog);
    }

    @Override
    public float getParticleTargetRadius() {
        return isLargeCog() ? 1.125f : .65f;
    }

    @Override
    public float getParticleInitialRadius() {
        return isLargeCog() ? 1f : .75f;
    }

    @Override
    public boolean isDedicatedCogWheel() {
        return true;
    }
}
