package com.zurrtum.create.content.kinetics.steamEngine;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.api.stress.BlockStressValues;
import com.zurrtum.create.content.kinetics.base.GeneratingKineticBlockEntity;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_7923;

public class PoweredShaftBlockEntity extends GeneratingKineticBlockEntity {

    public class_2338 enginePos;
    public float engineEfficiency;
    public int movementDirection;
    public int initialTicks;
    public class_2248 capacityKey;

    public PoweredShaftBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.POWERED_SHAFT, pos, state);
        movementDirection = 1;
        initialTicks = 3;
    }

    @Override
    public void tick() {
        super.tick();
        if (initialTicks > 0)
            initialTicks--;
    }

    public void update(class_2338 sourcePos, int direction, float efficiency) {
        class_2338 key = field_11867.method_10059(sourcePos);
        enginePos = key;
        float prev = engineEfficiency;
        engineEfficiency = efficiency;
        int prevDirection = this.movementDirection;
        if (class_3532.method_15347(efficiency, prev) && prevDirection == direction)
            return;

        capacityKey = field_11863.method_8320(sourcePos).method_26204();
        this.movementDirection = direction;
        updateGeneratedRotation();
    }

    public void remove(class_2338 sourcePos) {
        if (!isPoweredBy(sourcePos))
            return;

        enginePos = null;
        engineEfficiency = 0;
        movementDirection = 0;
        capacityKey = null;
        updateGeneratedRotation();
    }

    public boolean canBePoweredBy(class_2338 globalPos) {
        return initialTicks == 0 && (enginePos == null || isPoweredBy(globalPos));
    }

    public boolean isPoweredBy(class_2338 globalPos) {
        class_2338 key = field_11867.method_10059(globalPos);
        return key.equals(enginePos);
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        view.method_71465("Direction", movementDirection);
        if (initialTicks > 0)
            view.method_71465("Warmup", initialTicks);
        if (enginePos != null && capacityKey != null) {
            view.method_71468("EnginePos", class_2338.field_25064, enginePos);
            view.method_71464("EnginePower", engineEfficiency);
            view.method_71468("EngineType", class_7923.field_41175.method_39673(), capacityKey);
        }
        super.write(view, clientPacket);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        movementDirection = view.method_71424("Direction", 0);
        initialTicks = view.method_71424("Warmup", 0);

        view.method_71426("EnginePos", class_2338.field_25064).ifPresentOrElse(
            pos -> {
                enginePos = pos;
                engineEfficiency = view.method_71423("EnginePower", 0);
                capacityKey = view.method_71426("EngineType", class_7923.field_41175.method_39673()).orElse(null);
            }, () -> {
                enginePos = null;
                engineEfficiency = 0;
            }
        );
    }

    @Override
    public float getGeneratedSpeed() {
        return getCombinedCapacity() > 0 ? movementDirection * 16 * getSpeedModifier() : 0;
    }

    private float getCombinedCapacity() {
        return capacityKey == null ? 0 : (float) (engineEfficiency * BlockStressValues.getCapacity(capacityKey));
    }

    private int getSpeedModifier() {
        return (int) (1 + (engineEfficiency >= 1 ? 3 : Math.min(2, Math.floor(engineEfficiency * 4))));
    }

    @Override
    public float calculateAddedStressCapacity() {
        float capacity = getCombinedCapacity() / getSpeedModifier();
        this.lastCapacityProvided = capacity;
        return capacity;
    }

    @Override
    public int getRotationAngleOffset(class_2351 axis) {
        int combinedCoords = axis.method_10173(field_11867.method_10263(), field_11867.method_10264(), field_11867.method_10260());
        return super.getRotationAngleOffset(axis) + (combinedCoords % 2 == 0 ? 180 : 0);
    }

}
