package com.zurrtum.create.content.kinetics.transmission.sequencer;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.api.contraption.transformable.TransformableBlock;
import com.zurrtum.create.content.contraptions.StructureTransform;
import com.zurrtum.create.content.kinetics.base.HorizontalAxisKineticBlock;
import com.zurrtum.create.content.kinetics.base.KineticBlock;
import com.zurrtum.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.block.WeakPowerControlBlock;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689.class_2690;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_3218;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_8235;
import net.minecraft.class_9904;
import org.jetbrains.annotations.Nullable;

public class SequencedGearshiftBlock extends HorizontalAxisKineticBlock implements IBE<SequencedGearshiftBlockEntity>, TransformableBlock, WeakPowerControlBlock {
    public static final class_2746 VERTICAL = class_2746.method_11825("vertical");
    public static final class_2758 STATE = class_2758.method_11867("state", 0, 5);

    public SequencedGearshiftBlock(class_4970.class_2251 properties) {
        super(properties);
    }

    @Override
    protected void method_9515(class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder.method_11667(STATE, VERTICAL));
    }

    @Override
    public void method_9612(
        class_2680 state,
        class_1937 level,
        class_2338 pos,
        class_2248 block,
        @Nullable class_9904 wireOrientation,
        boolean isMoving
    ) {
        if (level.method_8608())
            return;
        if (!level.method_8397().method_8677(pos, this))
            level.method_64310(pos, this, 1);
    }

    @Override
    public void method_9588(class_2680 state, class_3218 worldIn, class_2338 pos, class_5819 r) {
        boolean previouslyPowered = state.method_11654(STATE) != 0;
        boolean isPowered = worldIn.method_49803(pos);
        withBlockEntityDo(worldIn, pos, sgte -> sgte.onRedstoneUpdate(isPowered, previouslyPowered));
    }

    @Override
    protected boolean areStatesKineticallyEquivalent(class_2680 oldState, class_2680 newState) {
        return false;
    }

    @Override
    public boolean hasShaftTowards(class_4538 world, class_2338 pos, class_2680 state, class_2350 face) {
        if (state.method_11654(VERTICAL))
            return face.method_10166().method_10178();
        return super.hasShaftTowards(world, pos, state, face);
    }

    @Override
    protected class_1269 method_55765(
        class_1799 stack,
        class_2680 state,
        class_1937 level,
        class_2338 pos,
        class_1657 player,
        class_1268 hand,
        class_3965 hitResult
    ) {
        if (stack.method_31574(AllItems.WRENCH))
            return class_1269.field_52423;
        if (stack.method_7909() instanceof class_1747 blockItem) {
            if (blockItem.method_7711() instanceof KineticBlock && hasShaftTowards(level, pos, state, hitResult.method_17780()))
                return class_1269.field_52423;
        }

        if (level.method_8608()) {
            withBlockEntityDo(level, pos, be -> AllClientHandle.INSTANCE.openSequencedGearshiftScreen(be));
        }
        return class_1269.field_5812;
    }

    @Override
    public class_2680 method_9605(class_1750 context) {
        class_2351 preferredAxis = RotatedPillarKineticBlock.getPreferredAxis(context);
        if (preferredAxis != null && (context.method_8036() == null || !context.method_8036().method_5715()))
            return withAxis(preferredAxis, context);
        return withAxis(context.method_7715().method_10166(), context);
    }

    @Override
    public class_1269 onWrenched(class_2680 state, class_1838 context) {
        class_2680 newState = state;

        if (context.method_8038().method_10166() != class_2351.field_11052)
            if (newState.method_11654(HORIZONTAL_AXIS) != context.method_8038().method_10166())
                newState = newState.method_28493(VERTICAL);

        return super.onWrenched(newState, context);
    }

    @Override
    public boolean shouldCheckWeakPower(class_2680 state, class_8235 level, class_2338 pos, class_2350 side) {
        return false;
    }

    private class_2680 withAxis(class_2351 axis, class_1750 context) {
        class_2680 state = method_9564().method_11657(VERTICAL, axis.method_10178());
        if (axis.method_10178())
            return state.method_11657(HORIZONTAL_AXIS, context.method_8042().method_10166());
        return state.method_11657(HORIZONTAL_AXIS, axis);
    }

    @Override
    public class_2351 getRotationAxis(class_2680 state) {
        if (state.method_11654(VERTICAL))
            return class_2351.field_11052;
        return super.getRotationAxis(state);
    }

    @Override
    public Class<SequencedGearshiftBlockEntity> getBlockEntityClass() {
        return SequencedGearshiftBlockEntity.class;
    }

    @Override
    public class_2591<? extends SequencedGearshiftBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.SEQUENCED_GEARSHIFT;
    }

    @Override
    public boolean method_9498(class_2680 p_149740_1_) {
        return true;
    }

    @Override
    public int method_9572(class_2680 state, class_1937 world, class_2338 pos, class_2350 direction) {
        return state.method_11654(STATE);
    }

    @Override
    public class_2680 transform(class_2680 state, StructureTransform transform) {
        if (transform.mirror != null) {
            state = method_9569(state, transform.mirror);
        }

        if (transform.rotationAxis == class_2351.field_11052) {
            return method_9598(state, transform.rotation);
        }

        if (transform.rotation.ordinal() % 2 == 1) {
            if (transform.rotationAxis != state.method_11654(HORIZONTAL_AXIS)) {
                return state.method_28493(VERTICAL);
            } else if (state.method_11654(VERTICAL)) {
                return state.method_28493(VERTICAL).method_28493(HORIZONTAL_AXIS);
            }
        }
        return state;
    }

}