package com.zurrtum.create.content.kinetics.waterwheel;

import com.mojang.serialization.MapCodec;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.api.equipment.goggles.IProxyHoveringInformation;
import com.zurrtum.create.content.equipment.wrench.IWrenchable;
import com.zurrtum.create.foundation.block.LandingEffectControlBlock;
import net.minecraft.class_10225;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2318;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2689.class_2690;
import net.minecraft.class_3218;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

public class WaterWheelStructuralBlock extends class_2318 implements IWrenchable, IProxyHoveringInformation, LandingEffectControlBlock {

    public static final MapCodec<WaterWheelStructuralBlock> field_46280 = method_54094(WaterWheelStructuralBlock::new);

    public WaterWheelStructuralBlock(class_2251 p_52591_) {
        super(p_52591_);
    }

    @Override
    protected void method_9515(class_2690<class_2248, class_2680> pBuilder) {
        super.method_9515(pBuilder.method_11667(field_10927));
    }

    @Override
    public class_1269 onWrenched(class_2680 state, class_1838 context) {
        return class_1269.field_5811;
    }

    @Override
    protected class_1799 method_9574(class_4538 world, class_2338 pos, class_2680 state, boolean includeData) {
        return AllItems.LARGE_WATER_WHEEL.method_7854();
    }

    @Override
    public class_1269 onSneakWrenched(class_2680 state, class_1838 context) {
        class_2338 clickedPos = context.method_8037();
        class_1937 level = context.method_8045();

        if (stillValid(level, clickedPos, state, false)) {
            class_2338 masterPos = getMaster(level, clickedPos, state);
            context = new class_1838(
                level,
                context.method_8036(),
                context.method_20287(),
                context.method_8041(),
                new class_3965(context.method_17698(), context.method_8038(), masterPos, context.method_17699())
            );
            state = level.method_8320(masterPos);
        }

        return IWrenchable.super.onSneakWrenched(state, context);
    }

    @Override
    protected class_1269 method_55765(
        class_1799 stack,
        class_2680 state,
        class_1937 level,
        class_2338 pos,
        class_1657 player,
        class_1268 hand,
        class_3965 hitResult
    ) {
        if (!stillValid(level, pos, state, false))
            return class_1269.field_5814;
        if (!(level.method_8321(getMaster(level, pos, state)) instanceof WaterWheelBlockEntity wwt))
            return class_1269.field_5814;
        return wwt.applyMaterialIfValid(stack);
    }

    @Override
    public void method_66388(class_2680 pState, class_3218 pLevel, class_2338 pPos, boolean pIsMoving) {
        if (stillValid(pLevel, pPos, pState, false))
            pLevel.method_22352(getMaster(pLevel, pPos, pState), true);
    }

    @Override
    public class_2680 method_9576(class_1937 pLevel, class_2338 pPos, class_2680 pState, class_1657 pPlayer) {
        if (stillValid(pLevel, pPos, pState, false)) {
            class_2338 masterPos = getMaster(pLevel, pPos, pState);
            pLevel.method_8517(masterPos.hashCode(), masterPos, -1);
            if (!pLevel.method_8608() && pPlayer.method_68878())
                pLevel.method_22352(masterPos, false);
        }
        return super.method_9576(pLevel, pPos, pState, pPlayer);
    }

    @Override
    public class_2680 method_9559(
        class_2680 pState,
        class_4538 pLevel,
        class_10225 tickView,
        class_2338 pCurrentPos,
        class_2350 pFacing,
        class_2338 pFacingPos,
        class_2680 pFacingState,
        class_5819 random
    ) {
        if (stillValid(pLevel, pCurrentPos, pState, false)) {
            class_2338 masterPos = getMaster(pLevel, pCurrentPos, pState);
            if (!tickView.method_8397().method_8674(masterPos, AllBlocks.LARGE_WATER_WHEEL))
                tickView.method_64310(masterPos, AllBlocks.LARGE_WATER_WHEEL, 1);
            return pState;
        }
        if (!(pLevel instanceof class_1937 level) || level.method_8608())
            return pState;
        if (!level.method_8397().method_8674(pCurrentPos, this))
            level.method_64310(pCurrentPos, this, 1);
        return pState;
    }

    public static class_2338 getMaster(class_1922 level, class_2338 pos, class_2680 state) {
        class_2350 direction = state.method_11654(field_10927);
        class_2338 targetedPos = pos.method_10093(direction);
        class_2680 targetedState = level.method_8320(targetedPos);
        if (targetedState.method_27852(AllBlocks.WATER_WHEEL_STRUCTURAL))
            return getMaster(level, targetedPos, targetedState);
        return targetedPos;
    }

    public boolean stillValid(class_1922 level, class_2338 pos, class_2680 state, boolean directlyAdjacent) {
        if (!state.method_27852(this))
            return false;

        class_2350 direction = state.method_11654(field_10927);
        class_2338 targetedPos = pos.method_10093(direction);
        class_2680 targetedState = level.method_8320(targetedPos);

        if (!directlyAdjacent && stillValid(level, targetedPos, targetedState, true))
            return true;
        return targetedState.method_26204() instanceof LargeWaterWheelBlock && targetedState.method_11654(LargeWaterWheelBlock.AXIS) != direction.method_10166();
    }

    @Override
    public void method_9588(class_2680 pState, class_3218 pLevel, class_2338 pPos, class_5819 pRandom) {
        if (!stillValid(pLevel, pPos, pState, false))
            pLevel.method_8501(pPos, class_2246.field_10124.method_9564());
    }

    @Override
    public boolean addLandingEffects(class_2680 state, class_3218 world, class_2338 pos, class_1309 entity, double distance) {
        return true;
    }

    @Override
    public class_2338 getInformationSource(class_1937 level, class_2338 pos, class_2680 state) {
        return stillValid(level, pos, state, false) ? getMaster(level, pos, state) : pos;
    }

    @Override
    protected @NotNull MapCodec<? extends class_2318> method_53969() {
        return field_46280;
    }
}
