package com.zurrtum.create.content.logistics.box;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1799;
import net.minecraft.class_2960;

import static com.zurrtum.create.Create.MOD_ID;

public class PackageStyles {
    public record PackageStyle(String namespace, String type, int width, int height, float riggingOffset, boolean rare) {
        public PackageStyle(String type, int width, int height, float riggingOffset, boolean rare) {
            this(MOD_ID, type, width, height, riggingOffset, rare);
        }

        public class_2960 getItemId() {
            String size = "_" + width + "x" + height;
            String id = type + "_package" + (rare ? "" : size);
            return class_2960.method_60655(namespace, id);
        }

        public class_2960 getModel() {
            if (type.equals("cardboard")) {
                return class_2960.method_60655(namespace, "item/package/cardboard_" + width + "x" + height);
            } else {
                return getItemId().method_45138("item/");
            }
        }

        public class_2960 getRiggingModel() {
            String size = width + "x" + height;
            return class_2960.method_60655(namespace, "item/package/rigging_" + size);
        }
    }

    public static final List<PackageItem> ALL_BOXES = new ArrayList<>();
    public static final List<PackageItem> STANDARD_BOXES = new ArrayList<>();
    public static final List<PackageItem> RARE_BOXES = new ArrayList<>();

    private static final Random STYLE_PICKER = new Random();
    private static final int RARE_CHANCE = 7500; // addons, have mercy

    public static class_1799 getRandomBox() {
        List<PackageItem> pool = STYLE_PICKER.nextInt(RARE_CHANCE) == 0 ? RARE_BOXES : STANDARD_BOXES;
        return new class_1799(pool.get(STYLE_PICKER.nextInt(pool.size())));
    }

    public static class_1799 getDefaultBox() {
        return new class_1799(ALL_BOXES.getFirst());
    }

    private static PackageStyle rare(String name) {
        return new PackageStyle("rare_" + name, 12, 10, 21f, true);
    }
}