package com.zurrtum.create.content.logistics.depot;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.zurrtum.create.content.kinetics.belt.transport.TransportedItemStack;
import com.zurrtum.create.content.logistics.box.PackageEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.item.ItemHelper;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3965;

public class SharedDepotBlockMethods {

    protected static DepotBehaviour get(class_1922 worldIn, class_2338 pos) {
        return BlockEntityBehaviour.get(worldIn, pos, DepotBehaviour.TYPE);
    }

    public static class_1269 onUse(
        class_1799 stack,
        class_2680 state,
        class_1937 level,
        class_2338 pos,
        class_1657 player,
        class_1268 hand,
        class_3965 ray
    ) {
        if (ray.method_17780() != class_2350.field_11036)
            return class_1269.field_52423;
        if (level.method_8608())
            return class_1269.field_5812;

        DepotBehaviour behaviour = get(level, pos);
        if (behaviour == null)
            return class_1269.field_52423;
        if (!behaviour.canAcceptItems.get())
            return class_1269.field_5812;

        boolean wasEmptyHanded = stack.method_7960();
        boolean shouldntPlaceItem = stack.method_31574(AllItems.MECHANICAL_ARM);

        class_1799 mainItemStack = behaviour.getHeldItemStack();
        if (!mainItemStack.method_7960()) {
            if (class_1799.method_31577(mainItemStack, stack)) {
                int remainder = mainItemStack.method_7947();
                int count = stack.method_7947();
                int extract = Math.min(remainder, stack.method_7914() - count);
                if (extract != 0) {
                    stack.method_7939(count + extract);
                    if (extract == remainder) {
                        mainItemStack = class_1799.field_8037;
                        behaviour.removeHeldItem();
                    } else {
                        mainItemStack.method_7939(remainder - extract);
                    }
                }
            }
            if (!mainItemStack.method_7960()) {
                player.method_31548().method_7398(mainItemStack);
                behaviour.removeHeldItem();
                level.method_8396(null, pos, class_3417.field_15197, class_3419.field_15248, .2f, 1f + level.method_8409().method_43057());
            }
        }
        boolean change = false;
        class_1263 outputs = behaviour.processingOutputBuffer;
        for (int i = 0, size = outputs.method_5439(); i < size; i++) {
            class_1799 itemStack = outputs.method_5441(i);
            if (itemStack.method_7960()) {
                continue;
            }
            player.method_31548().method_7398(itemStack);
            change = true;
        }
        if (change) {
            outputs.method_5431();
        }

        if (!wasEmptyHanded && !shouldntPlaceItem) {
            TransportedItemStack transported = new TransportedItemStack(stack);
            transported.insertedFrom = player.method_5735();
            transported.prevBeltPosition = .25f;
            transported.beltPosition = .25f;
            behaviour.setHeldItem(transported);
            player.method_6122(hand, class_1799.field_8037);
            AllSoundEvents.DEPOT_SLIDE.playOnServer(level, pos);
        }

        behaviour.blockEntity.notifyUpdate();
        return class_1269.field_5812;
    }

    public static void onLanded(class_1922 worldIn, class_1297 entityIn) {
        class_1799 asItem = ItemHelper.fromItemEntity(entityIn);
        if (asItem.method_7960())
            return;
        if (entityIn.method_73183().method_8608())
            return;

        class_2338 pos = entityIn.method_24515();
        DirectBeltInputBehaviour inputBehaviour = BlockEntityBehaviour.get(worldIn, pos, DirectBeltInputBehaviour.TYPE);
        if (inputBehaviour == null)
            return;
        class_243 targetLocation = VecHelper.getCenterOf(pos).method_1031(0, 5 / 16f, 0);
        if (!PackageEntity.centerPackage(entityIn, targetLocation))
            return;

        class_1799 remainder = inputBehaviour.handleInsertion(asItem, class_2350.field_11033, false);
        if (entityIn instanceof class_1542)
            ((class_1542) entityIn).method_6979(remainder);
        if (remainder.method_7960())
            entityIn.method_31472();
    }

    public static int getComparatorInputOverride(class_2680 blockState, class_1937 worldIn, class_2338 pos) {
        DepotBehaviour depotBehaviour = get(worldIn, pos);
        if (depotBehaviour == null)
            return 0;
        float f = depotBehaviour.getPresentStackSize();
        Integer max = depotBehaviour.maxStackSize.get();
        f = f / (max == 0 ? 64 : max);
        return class_3532.method_15340(class_3532.method_15375(f * 14.0F) + (f > 0 ? 1 : 0), 0, 15);
    }

}
