package com.zurrtum.create.content.logistics.factoryBoard;

import com.mojang.serialization.MapCodec;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.api.schematic.requirement.SpecialBlockItemRequirement;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.equipment.wrench.IWrenchable;
import com.zurrtum.create.content.logistics.packagerLink.LogisticallyLinkedBlockItem;
import com.zurrtum.create.content.schematics.requirement.ItemRequirement;
import com.zurrtum.create.foundation.advancement.AdvancementBehaviour;
import com.zurrtum.create.foundation.block.BreakControlBlock;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.block.ProperWaterloggedBlock;
import net.minecraft.block.*;
import net.minecraft.class_10225;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2341;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2738;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3726;
import net.minecraft.class_3727;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5134;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

import java.util.UUID;

public class FactoryPanelBlock extends class_2341 implements ProperWaterloggedBlock, IBE<FactoryPanelBlockEntity>, IWrenchable, SpecialBlockItemRequirement, BreakControlBlock {
    public static final MapCodec<FactoryPanelBlock> field_46280 = method_54094(FactoryPanelBlock::new);

    public static final class_2746 POWERED = class_2741.field_12484;

    public FactoryPanelBlock(class_2251 p_53182_) {
        super(p_53182_);
        method_9590(method_9564().method_11657(WATERLOGGED, false).method_11657(POWERED, false));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> pBuilder) {
        super.method_9515(pBuilder.method_11667(field_11007, field_11177, WATERLOGGED, POWERED));
    }

    @Override
    public boolean method_9558(class_2680 pState, class_4538 pLevel, class_2338 pPos) {
        return canAttachLenient(pLevel, pPos, method_10119(pState).method_10153());
    }

    public static boolean canAttachLenient(class_4538 pReader, class_2338 pPos, class_2350 pDirection) {
        class_2338 blockpos = pPos.method_10093(pDirection);
        return !pReader.method_8320(blockpos).method_26220(pReader, blockpos).method_1110();
    }

    @Override
    public class_2680 method_9605(class_1750 pContext) {
        class_2680 stateForPlacement = super.method_9605(pContext);
        if (stateForPlacement == null)
            return null;
        if (stateForPlacement.method_11654(field_11007) == class_2738.field_12475)
            stateForPlacement = stateForPlacement.method_11657(field_11177, stateForPlacement.method_11654(field_11177).method_10153());

        class_1937 level = pContext.method_8045();
        class_2338 pos = pContext.method_8037();
        class_2680 blockState = level.method_8320(pos);
        FactoryPanelBlockEntity fpbe = getBlockEntity(level, pos);

        class_243 location = pContext.method_17698();
        if (blockState.method_27852(this) && location != null && fpbe != null) {
            if (!level.method_8608()) {
                PanelSlot targetedSlot = getTargetedSlot(pos, blockState, location);
                class_1799 panelItem = FactoryPanelBlockItem.fixCtrlCopiedStack(pContext.method_8041());
                UUID networkFromStack = LogisticallyLinkedBlockItem.networkFromStack(panelItem);
                class_1657 pPlayer = pContext.method_8036();

                if (fpbe.addPanel(targetedSlot, networkFromStack) && pPlayer != null) {
                    pPlayer.method_7353(class_2561.method_43471("create.logistically_linked.connected"), true);

                    if (!pPlayer.method_68878()) {
                        panelItem.method_7934(1);
                        if (panelItem.method_7960())
                            pPlayer.method_6122(pContext.method_20287(), class_1799.field_8037);
                    }
                }
            }
            stateForPlacement = blockState;
        }

        return withWater(stateForPlacement, pContext);
    }

    @Override
    public class_1269 onSneakWrenched(class_2680 state, class_1838 context) {
        class_1937 world = context.method_8045();
        class_2338 pos = context.method_8037();
        class_1657 player = context.method_8036();
        PanelSlot slot = getTargetedSlot(pos, state, context.method_17698());

        if (!(world instanceof class_3218))
            return class_1269.field_5812;

        return onBlockEntityUse(
            world, pos, be -> {
                ServerFactoryPanelBehaviour behaviour = be.panels.get(slot);
                if (behaviour == null || !behaviour.isActive())
                    return class_1269.field_5812;

                //TODO
                //                BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, world.getBlockState(pos), player);
                //                NeoForge.EVENT_BUS.post(event);
                //                if (event.isCanceled())
                //                    return ActionResult.SUCCESS;

                if (!be.removePanel(slot))
                    return class_1269.field_5812;

                if (!player.method_68878())
                    player.method_31548().method_7398(AllItems.FACTORY_GAUGE.method_7854());

                IWrenchable.playRemoveSound(world, pos);
                if (be.activePanels() == 0)
                    world.method_22352(pos, false);

                return class_1269.field_5812;
            }
        );
    }

    @Override
    public void method_9567(class_1937 pLevel, class_2338 pPos, class_2680 pState, class_1309 pPlacer, class_1799 pStack) {
        super.method_9567(pLevel, pPos, pState, pPlacer, pStack);
        if (pPlacer == null)
            return;
        AdvancementBehaviour.setPlacedBy(pLevel, pPos, pPlacer);
        double range = pPlacer.method_45325(class_5134.field_47758) + 1;
        class_239 hitResult = pPlacer.method_5745(range, 1, false);
        class_243 location = hitResult.method_17784();
        if (location == null)
            return;
        PanelSlot initialSlot = getTargetedSlot(pPos, pState, location);
        withBlockEntityDo(pLevel, pPos, fpbe -> fpbe.addPanel(initialSlot, LogisticallyLinkedBlockItem.networkFromStack(pStack)));
    }

    @Override
    protected class_1269 method_55765(
        class_1799 stack,
        class_2680 state,
        class_1937 level,
        class_2338 pos,
        class_1657 player,
        class_1268 hand,
        class_3965 hitResult
    ) {
        if (player == null)
            return class_1269.field_52423;
        if (level.method_8608())
            return class_1269.field_5812;
        if (!stack.method_31574(AllItems.FACTORY_GAUGE))
            return class_1269.field_5812;
        class_243 location = hitResult.method_17784();
        if (location == null)
            return class_1269.field_5812;

        if (!FactoryPanelBlockItem.isTuned(stack)) {
            AllSoundEvents.DENY.playOnServer(level, pos);
            player.method_7353(class_2561.method_43471("create.factory_panel.tune_before_placing"), true);
            return class_1269.field_5814;
        }

        PanelSlot newSlot = getTargetedSlot(pos, state, location);
        withBlockEntityDo(
            level, pos, fpbe -> {
                if (!fpbe.addPanel(newSlot, LogisticallyLinkedBlockItem.networkFromStack(FactoryPanelBlockItem.fixCtrlCopiedStack(stack))))
                    return;
                player.method_7353(class_2561.method_43471("create.logistically_linked.connected"), true);
                level.method_45447(null, pos, field_23162.method_10598(), class_3419.field_15245);
                if (player.method_68878())
                    return;
                stack.method_7934(1);
                if (stack.method_7960())
                    player.method_6122(hand, class_1799.field_8037);
            }
        );
        return class_1269.field_5812;
    }

    @Override
    public boolean onDestroyedByPlayer(class_2680 state, class_1937 level, class_2338 pos, class_1657 player) {
        return !tryDestroySubPanelFirst(state, level, pos, player);
    }

    private boolean tryDestroySubPanelFirst(class_2680 state, class_1937 level, class_2338 pos, class_1657 player) {
        double range = player.method_45325(class_5134.field_47758) + 1;
        class_239 hitResult = player.method_5745(range, 1, false);
        class_243 location = hitResult.method_17784();
        PanelSlot destroyedSlot = getTargetedSlot(pos, state, location);
        return class_1269.field_5812 == onBlockEntityUse(
            level, pos, fpbe -> {
                if (fpbe.activePanels() < 2)
                    return class_1269.field_5814;
                if (!fpbe.removePanel(destroyedSlot))
                    return class_1269.field_5814;
                if (!player.method_68878())
                    method_9577(level, pos, AllItems.FACTORY_GAUGE.method_7854());
                return class_1269.field_5812;
            }
        );
    }

    @Override
    public boolean method_9506(class_2680 pState) {
        return true;
    }

    @Override
    public int method_9524(class_2680 pBlockState, class_1922 pBlockAccess, class_2338 pPos, class_2350 pSide) {
        return pBlockState.method_11654(POWERED) ? 15 : 0;
    }

    @Override
    public int method_9603(class_2680 pBlockState, class_1922 pBlockAccess, class_2338 pPos, class_2350 pSide) {
        return pBlockState.method_11654(POWERED) && method_10119(pBlockState) == pSide ? 15 : 0;
    }

    @Override
    public boolean method_9616(class_2680 pState, class_1750 pUseContext) {
        if (!pUseContext.method_8041().method_31574(AllItems.FACTORY_GAUGE))
            return false;
        class_243 location = pUseContext.method_17698();

        class_2338 pos = pUseContext.method_8037();
        PanelSlot slot = getTargetedSlot(pos, pState, location);
        FactoryPanelBlockEntity blockEntity = getBlockEntity(pUseContext.method_8045(), pos);

        if (blockEntity == null)
            return false;
        return !blockEntity.panels.get(slot).isActive();
    }

    @Override
    public class_265 method_9549(class_2680 pState, class_1922 pLevel, class_2338 pPos, class_3726 pContext) {
        if (pContext instanceof class_3727 ecc && ecc.method_32480() == null)
            return method_9530(pState, pLevel, pPos, pContext);
        return class_259.method_1073();
    }

    @Override
    public class_265 method_9530(class_2680 pState, class_1922 pLevel, class_2338 pPos, class_3726 pContext) {
        FactoryPanelBlockEntity blockEntity = getBlockEntity(pLevel, pPos);
        if (blockEntity != null)
            return blockEntity.getShape();
        return AllShapes.FACTORY_PANEL_FALLBACK.get(method_10119(pState));
    }

    @Override
    public class_2680 method_9559(
        class_2680 pState,
        class_4538 pLevel,
        class_10225 tickView,
        class_2338 pCurrentPos,
        class_2350 pFacing,
        class_2338 pFacingPos,
        class_2680 pFacingState,
        class_5819 random
    ) {
        updateWater(pLevel, tickView, pState, pCurrentPos);
        return super.method_9559(pState, pLevel, tickView, pCurrentPos, pFacing, pFacingPos, pFacingState, random);
    }

    @Override
    public class_3610 method_9545(class_2680 pState) {
        return fluidState(pState);
    }

    public static class_2350 connectedDirection(class_2680 state) {
        return method_10119(state);
    }

    public static PanelSlot getTargetedSlot(class_2338 pos, class_2680 blockState, class_243 clickLocation) {
        double bestDistance = Double.MAX_VALUE;
        PanelSlot bestSlot = PanelSlot.BOTTOM_LEFT;
        class_243 localClick = clickLocation.method_1020(class_243.method_24954(pos));
        float xRot = class_3532.field_29848 * FactoryPanelBlock.getXRot(blockState);
        float yRot = class_3532.field_29848 * FactoryPanelBlock.getYRot(blockState);

        for (PanelSlot slot : PanelSlot.values()) {
            class_243 vec = new class_243(.25 + slot.xOffset * .5, 0, .25 + slot.yOffset * .5);
            vec = VecHelper.rotateCentered(vec, 180, class_2351.field_11052);
            vec = VecHelper.rotateCentered(vec, xRot + 90, class_2351.field_11048);
            vec = VecHelper.rotateCentered(vec, yRot, class_2351.field_11052);

            double diff = vec.method_1025(localClick);
            if (diff > bestDistance)
                continue;
            bestDistance = diff;
            bestSlot = slot;
        }

        return bestSlot;
    }

    @Override
    public Class<FactoryPanelBlockEntity> getBlockEntityClass() {
        return FactoryPanelBlockEntity.class;
    }

    @Override
    public class_2591<? extends FactoryPanelBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.FACTORY_PANEL;
    }

    public static float getXRot(class_2680 state) {
        class_2738 face = state.method_61767(FactoryPanelBlock.field_11007, class_2738.field_12475);
        return face == class_2738.field_12473 ? class_3532.field_29844 / 2 : face == class_2738.field_12475 ? -class_3532.field_29844 / 2 : 0;
    }

    public static float getYRot(class_2680 state) {
        class_2350 facing = state.method_61767(FactoryPanelBlock.field_11177, class_2350.field_11035);
        class_2738 face = state.method_61767(FactoryPanelBlock.field_11007, class_2738.field_12475);
        return (face == class_2738.field_12473 ? class_3532.field_29844 : 0) + AngleHelper.rad(AngleHelper.horizontalAngle(facing));
    }

    @Override
    public ItemRequirement getRequiredItems(class_2680 state, class_2586 blockEntity) {
        return ItemRequirement.NONE;
    }

    @Override
    protected @NotNull MapCodec<? extends class_2341> method_53969() {
        return field_46280;
    }
}
