package com.zurrtum.create.content.logistics.factoryBoard;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.logistics.packager.PackagerBlockEntity;
import com.zurrtum.create.content.logistics.packager.repackager.RepackagerBlockEntity;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2498;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.util.math.*;
import org.jetbrains.annotations.Nullable;

import java.util.EnumMap;
import java.util.List;
import java.util.UUID;

public class FactoryPanelBlockEntity extends SmartBlockEntity {
    public EnumMap<PanelSlot, ServerFactoryPanelBehaviour> panels;

    public boolean redraw;
    public boolean restocker;
    public class_265 lastShape;

    public FactoryPanelBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.FACTORY_PANEL, pos, state);
        restocker = false;
    }

    @Override
    protected class_238 createRenderBoundingBox() {
        return new class_238(field_11867).method_1014(8);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        panels = new EnumMap<>(PanelSlot.class);
        redraw = true;
        for (PanelSlot slot : PanelSlot.values()) {
            ServerFactoryPanelBehaviour e = new ServerFactoryPanelBehaviour(this, slot);
            panels.put(slot, e);
            behaviours.add(e);
        }
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.FACTORY_GAUGE);
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (field_11863.method_8608())
            return;

        if (activePanels() == 0)
            field_11863.method_8501(field_11867, class_2246.field_10124.method_9564());

        class_2680 state = method_11010();
        if (state.method_27852(AllBlocks.FACTORY_GAUGE)) {
            boolean shouldBeRestocker = field_11863.method_8320(field_11867.method_10093(FactoryPanelBlock.connectedDirection(state).method_10153()))
                .method_27852(AllBlocks.PACKAGER);
            if (restocker == shouldBeRestocker)
                return;
            restocker = shouldBeRestocker;
            redraw = true;
            sendData();
        }
    }

    @Nullable
    public PackagerBlockEntity getRestockedPackager() {
        class_2680 state = method_11010();
        if (!restocker || !state.method_27852(AllBlocks.FACTORY_GAUGE))
            return null;
        class_2338 packagerPos = field_11867.method_10093(FactoryPanelBlock.connectedDirection(state).method_10153());
        if (!field_11863.method_8477(packagerPos))
            return null;
        class_2586 be = field_11863.method_8321(packagerPos);
        if (!(be instanceof PackagerBlockEntity pbe))
            return null;
        if (pbe instanceof RepackagerBlockEntity)
            return null;
        return pbe;
    }

    public int activePanels() {
        int result = 0;
        for (ServerFactoryPanelBehaviour panelBehaviour : panels.values())
            if (panelBehaviour.isActive())
                result++;
        return result;
    }

    @Override
    public void remove() {
        for (ServerFactoryPanelBehaviour panelBehaviour : panels.values())
            if (panelBehaviour.isActive())
                panelBehaviour.disconnectAll();
        super.remove();
    }

    @Override
    public void destroy() {
        super.destroy();
        int panelCount = activePanels();
        if (panelCount > 1)
            class_2248.method_9577(field_11863, field_11867, new class_1799(AllItems.FACTORY_GAUGE, panelCount - 1));
    }

    public boolean addPanel(PanelSlot slot, UUID frequency) {
        ServerFactoryPanelBehaviour behaviour = panels.get(slot);
        if (behaviour != null && !behaviour.isActive()) {
            behaviour.enable();
            if (frequency != null)
                behaviour.setNetwork(frequency);
            redraw = true;
            lastShape = null;

            if (activePanels() > 1) {
                class_2498 soundType = method_11010().method_26231();
                field_11863.method_8396(
                    null,
                    field_11867,
                    soundType.method_10598(),
                    class_3419.field_15245,
                    (soundType.method_10597() + 1.0F) / 2.0F,
                    soundType.method_10599() * 0.8F
                );
            }

            return true;
        }
        return false;
    }

    public boolean removePanel(PanelSlot slot) {
        ServerFactoryPanelBehaviour behaviour = panels.get(slot);
        if (behaviour != null && behaviour.isActive()) {
            behaviour.disable();
            redraw = true;
            lastShape = null;

            if (activePanels() > 0) {
                class_2498 soundType = method_11010().method_26231();
                field_11863.method_8396(
                    null,
                    field_11867,
                    soundType.method_10595(),
                    class_3419.field_15245,
                    (soundType.method_10597() + 1.0F) / 2.0F,
                    soundType.method_10599() * 0.8F
                );
            }

            return true;
        }
        return false;
    }

    public class_265 getShape() {
        if (lastShape != null)
            return lastShape;

        float xRot = class_3532.field_29848 * FactoryPanelBlock.getXRot(method_11010()) + 90;
        float yRot = class_3532.field_29848 * FactoryPanelBlock.getYRot(method_11010());
        class_2350 connectedDirection = FactoryPanelBlock.connectedDirection(method_11010());
        class_243 inflateAxes = VecHelper.axisAlingedPlaneOf(connectedDirection);

        lastShape = class_259.method_1073();

        for (ServerFactoryPanelBehaviour behaviour : panels.values()) {
            if (!behaviour.isActive())
                continue;
            FactoryPanelPosition panelPosition = behaviour.getPanelPosition();
            class_243 vec = new class_243(.25 + panelPosition.slot().xOffset * .5, 1 / 16f, .25 + panelPosition.slot().yOffset * .5);
            vec = VecHelper.rotateCentered(vec, 180, class_2351.field_11052);
            vec = VecHelper.rotateCentered(vec, xRot, class_2351.field_11048);
            vec = VecHelper.rotateCentered(vec, yRot, class_2351.field_11052);
            class_238 bb = new class_238(vec, vec).method_1014(1 / 16f).method_1009(inflateAxes.field_1352 * 3 / 16f, inflateAxes.field_1351 * 3 / 16f, inflateAxes.field_1350 * 3 / 16f);
            lastShape = class_259.method_1084(lastShape, class_259.method_1078(bb));
        }

        return lastShape;
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        restocker = view.method_71433("Restocker", false);
        if (clientPacket && view.method_71433("Redraw", false)) {
            lastShape = null;
            field_11863.method_8413(method_11016(), method_11010(), method_11010(), 16);
        }
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);
        view.method_71472("Restocker", restocker);
        if (clientPacket && redraw) {
            view.method_71472("Redraw", true);
            redraw = false;
        }
    }
}
