package com.zurrtum.create.content.logistics.filter;

import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.content.logistics.box.PackageItem;
import com.zurrtum.create.foundation.gui.menu.MenuBase;
import com.zurrtum.create.foundation.gui.menu.MenuProvider;
import com.zurrtum.create.foundation.item.ItemHelper;
import com.zurrtum.create.foundation.recipe.ItemCopyingRecipe.SupportsItemCopying;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_10712;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5244;
import net.minecraft.class_9129;
import net.minecraft.class_9331;
import net.minecraft.class_9336;

public abstract class FilterItem extends class_1792 implements MenuProvider, SupportsItemCopying {
    public static ListFilterItem regular(class_1793 properties) {
        return new ListFilterItem(properties);
    }

    public static AttributeFilterItem attribute(class_1793 properties) {
        return new AttributeFilterItem(properties);
    }

    public static PackageFilterItem address(class_1793 properties) {
        return new PackageFilterItem(properties);
    }

    protected FilterItem(class_1793 properties) {
        super(properties);
    }

    @NotNull
    @Override
    public class_1269 method_7884(class_1838 context) {
        if (context.method_8036() == null)
            return class_1269.field_5811;
        return method_7836(context.method_8045(), context.method_8036(), context.method_20287());
    }

    @Override
    @SuppressWarnings("deprecation")
    public void method_67187(
        class_1799 stack,
        class_1792.class_9635 context,
        class_10712 displayComponent,
        Consumer<class_2561> textConsumer,
        class_1836 type
    ) {
        if (AllClientHandle.INSTANCE.shiftDown())
            return;
        List<class_2561> makeSummary = makeSummary(stack);
        if (makeSummary.isEmpty())
            return;
        textConsumer.accept(class_5244.field_41874);
        makeSummary.forEach(textConsumer);
    }

    public abstract List<class_2561> makeSummary(class_1799 filter);

    @Override
    public class_1269 method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        if (!player.method_5715() && hand == class_1268.field_5808) {
            if (!world.method_8608() && player instanceof class_3222 serverPlayer)
                openHandledScreen(serverPlayer);
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    @Override
    public abstract @Nullable MenuBase<?> createMenu(int id, class_1661 inv, class_1657 player, class_9129 extraData);

    @Override
    public class_2561 getDisplayName() {
        return method_63680();
    }

    public static boolean testDirect(class_1799 filter, class_1799 stack, boolean matchNBT) {
        if (matchNBT) {
            if (PackageItem.isPackage(filter) && PackageItem.isPackage(stack))
                return doPackagesHaveSameData(filter, stack);

            return class_1799.method_31577(filter, stack);
        }

        if (PackageItem.isPackage(filter) && PackageItem.isPackage(stack))
            return true;

        return ItemHelper.sameItem(filter, stack);
    }

    public static boolean doPackagesHaveSameData(@NotNull class_1799 a, @NotNull class_1799 b) {
        if (a.method_7960())
            return false;
        if (!class_1799.method_31577(a, b))
            return false;
        for (class_9336<?> component : a.method_57353()) {
            class_9331<?> type = component.comp_2443();
            if (type.equals(AllDataComponents.PACKAGE_ORDER_DATA) || type.equals(AllDataComponents.PACKAGE_ORDER_CONTEXT))
                continue;
            if (!Objects.equals(a.method_58694(type), b.method_58694(type)))
                return false;
        }
        return true;
    }

    public abstract class_9331<?> getComponentType();

    public abstract FilterItemStack makeStackWrapper(class_1799 filter);

    public abstract class_1799[] getFilterItems(class_1799 stack);
}
