package com.zurrtum.create.content.logistics.filter;

import com.mojang.serialization.Codec;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.content.fluids.transfer.GenericItemEmptying;
import com.zurrtum.create.content.logistics.box.PackageItem;
import com.zurrtum.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.zurrtum.create.infrastructure.component.AttributeFilterWhitelistMode;
import com.zurrtum.create.infrastructure.component.ItemAttributeEntry;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_9334;

public class FilterItemStack {
    public static final Codec<FilterItemStack> CODEC = class_1799.field_49266.xmap(FilterItemStack::of, FilterItemStack::item);
    private final class_1799 filterItemStack;
    private boolean fluidExtracted;
    private FluidStack filterFluidStack;

    public static FilterItemStack of(class_1799 filter) {
        if (!filter.method_57380().method_57848() && filter.method_7909() instanceof FilterItem item) {
            trimFilterComponents(filter);
            return item.makeStackWrapper(filter);
        }

        return new FilterItemStack(filter);
    }

    public static FilterItemStack empty() {
        return of(class_1799.field_8037);
    }

    private static void trimFilterComponents(class_1799 filter) {
        filter.method_57381(class_9334.field_49633);
        filter.method_57381(class_9334.field_49636);
    }

    public boolean isEmpty() {
        return filterItemStack.method_7960();
    }

    public class_1799 item() {
        return filterItemStack;
    }

    public FluidStack fluid(class_1937 level) {
        resolveFluid(level);
        return filterFluidStack;
    }

    public boolean isFilterItem() {
        return filterItemStack.method_7909() instanceof FilterItem;
    }

    //

    public boolean test(class_1937 world, class_1799 stack) {
        return test(world, stack, false);
    }

    public boolean test(class_1937 world, FluidStack stack) {
        return test(world, stack, true);
    }

    public boolean test(class_1937 world, class_1799 stack, boolean matchNBT) {
        if (isEmpty())
            return true;
        return FilterItem.testDirect(filterItemStack, stack, matchNBT);
    }

    public boolean test(class_1937 world, FluidStack stack, boolean matchNBT) {
        if (isEmpty())
            return true;
        if (stack.isEmpty())
            return false;

        resolveFluid(world);

        if (filterFluidStack.isEmpty())
            return false;
        if (!matchNBT)
            return filterFluidStack.getFluid().method_15780(stack.getFluid());
        return FluidStack.areFluidsAndComponentsEqualIgnoreCapacity(filterFluidStack, stack);
    }

    //

    private void resolveFluid(class_1937 world) {
        if (!fluidExtracted) {
            fluidExtracted = true;
            if (GenericItemEmptying.canItemBeEmptied(world, filterItemStack))
                filterFluidStack = GenericItemEmptying.emptyItem(world, filterItemStack, true).getFirst();
        }
    }

    protected FilterItemStack(class_1799 filter) {
        filterItemStack = filter;
        filterFluidStack = FluidStack.EMPTY;
        fluidExtracted = false;
    }

    public static class ListFilterItemStack extends FilterItemStack {

        public List<FilterItemStack> containedItems;
        public boolean shouldRespectNBT;
        public boolean isBlacklist;

        public ListFilterItemStack(class_1799 filter) {
            super(filter);
            boolean hasFilterItems = filter.method_57826(AllDataComponents.FILTER_ITEMS);

            containedItems = new ArrayList<>();
            for (class_1799 stack : ((ListFilterItem) filter.method_7909()).getFilterItemHandler(filter)) {
                if (!stack.method_7960())
                    containedItems.add(FilterItemStack.of(stack));
            }

            shouldRespectNBT = hasFilterItems && filter.method_58695(AllDataComponents.FILTER_ITEMS_RESPECT_NBT, false);
            isBlacklist = hasFilterItems && filter.method_58695(AllDataComponents.FILTER_ITEMS_BLACKLIST, false);
        }

        @Override
        public boolean test(class_1937 world, class_1799 stack, boolean matchNBT) {
            for (FilterItemStack filterItemStack : containedItems)
                if (filterItemStack.test(world, stack, shouldRespectNBT))
                    return !isBlacklist;
            return isBlacklist;
        }

        @Override
        public boolean test(class_1937 world, FluidStack stack, boolean matchNBT) {
            for (FilterItemStack filterItemStack : containedItems)
                if (filterItemStack.test(world, stack, shouldRespectNBT))
                    return !isBlacklist;
            return isBlacklist;
        }

    }

    public static class AttributeFilterItemStack extends FilterItemStack {
        public AttributeFilterWhitelistMode whitelistMode;
        public List<Pair<ItemAttribute, Boolean>> attributeTests;

        public AttributeFilterItemStack(class_1799 filter) {
            super(filter);
            boolean defaults = !filter.method_57826(AllDataComponents.ATTRIBUTE_FILTER_MATCHED_ATTRIBUTES);

            attributeTests = new ArrayList<>();
            whitelistMode = filter.method_58695(AllDataComponents.ATTRIBUTE_FILTER_WHITELIST_MODE, AttributeFilterWhitelistMode.WHITELIST_DISJ);

            List<ItemAttributeEntry> attributes = defaults ? new ArrayList<>() : filter.method_58694(AllDataComponents.ATTRIBUTE_FILTER_MATCHED_ATTRIBUTES);
            //noinspection DataFlowIssue
            for (ItemAttributeEntry attributeEntry : attributes) {
                ItemAttribute attribute = attributeEntry.attribute();
                if (attribute != null)
                    attributeTests.add(Pair.of(attribute, attributeEntry.inverted()));
            }
        }

        @Override
        public boolean test(class_1937 world, FluidStack stack, boolean matchNBT) {
            return false;
        }

        @Override
        public boolean test(class_1937 world, class_1799 stack, boolean matchNBT) {
            if (attributeTests.isEmpty())
                return super.test(world, stack, matchNBT);
            for (Pair<ItemAttribute, Boolean> test : attributeTests) {
                ItemAttribute attribute = test.getFirst();
                boolean inverted = test.getSecond();
                boolean matches = attribute.appliesTo(stack, world) != inverted;

                if (matches) {
                    switch (whitelistMode) {
                        case BLACKLIST -> {
                            return false;
                        }
                        case WHITELIST_CONJ -> {
                            continue;
                        }
                        case WHITELIST_DISJ -> {
                            return true;
                        }
                    }
                } else {
                    switch (whitelistMode) {
                        case BLACKLIST, WHITELIST_DISJ -> {
                            continue;
                        }
                        case WHITELIST_CONJ -> {
                            return false;
                        }
                    }
                }
            }

            return switch (whitelistMode) {
                case BLACKLIST, WHITELIST_CONJ -> true;
                case WHITELIST_DISJ -> false;
            };

        }

    }

    public static class PackageFilterItemStack extends FilterItemStack {

        public String filterString;

        public PackageFilterItemStack(class_1799 filter) {
            super(filter);
            filterString = PackageItem.getAddress(filter);
        }

        @Override
        public boolean test(class_1937 world, class_1799 stack, boolean matchNBT) {
            return (filterString.isBlank() && super.test(world, stack, matchNBT)) || PackageItem.isPackage(stack) && PackageItem.matchAddress(
                stack,
                filterString
            );
        }

        @Override
        public boolean test(class_1937 world, FluidStack stack, boolean matchNBT) {
            return false;
        }

    }
}
