package com.zurrtum.create.content.logistics.item.filter.attribute.attributes;

import com.mojang.serialization.MapCodec;
import com.zurrtum.create.AllItemAttributeTypes;
import com.zurrtum.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.zurrtum.create.content.logistics.item.filter.attribute.ItemAttributeType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_6880;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public record EnchantAttribute(@Nullable class_6880<class_1887> enchantment) implements ItemAttribute {
    public static final MapCodec<EnchantAttribute> CODEC = class_1887.field_51644.xmap(EnchantAttribute::new, EnchantAttribute::enchantment)
        .fieldOf("value");

    public static final class_9139<class_9129, EnchantAttribute> PACKET_CODEC = class_1887.field_51950.method_56432(
        EnchantAttribute::new,
        EnchantAttribute::enchantment
    );

    @Override
    public boolean appliesTo(class_1799 itemStack, class_1937 level) {
        return class_1890.method_57532(itemStack).method_57534().contains(enchantment);
    }

    @Override
    public String getTranslationKey() {
        return "has_enchant";
    }

    @Override
    public Object[] getTranslationParameters() {
        String parameter = "";
        if (enchantment != null)
            parameter = enchantment.comp_349().comp_2686().getString();
        return new Object[]{parameter};
    }

    @Override
    public ItemAttributeType getType() {
        return AllItemAttributeTypes.HAS_ENCHANT;
    }

    public static class Type implements ItemAttributeType {
        @Override
        public @NotNull ItemAttribute createAttribute() {
            return new EnchantAttribute(null);
        }

        @Override
        public List<ItemAttribute> getAllAttributes(class_1799 stack, class_1937 level) {
            List<ItemAttribute> list = new ArrayList<>();

            for (class_6880<class_1887> enchantmentHolder : class_1890.method_57532(stack).method_57534()) {
                list.add(new EnchantAttribute(enchantmentHolder));
            }

            return list;
        }

        @Override
        public MapCodec<? extends ItemAttribute> codec() {
            return CODEC;
        }

        @Override
        public class_9139<? super class_9129, ? extends ItemAttribute> packetCodec() {
            return PACKET_CODEC;
        }
    }
}
