package com.zurrtum.create.content.logistics.item.filter.attribute.attributes;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.zurrtum.create.AllItemAttributeTypes;
import com.zurrtum.create.catnip.codecs.stream.CatnipStreamCodecBuilders;
import com.zurrtum.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.zurrtum.create.content.logistics.item.filter.attribute.ItemAttributeType;
import io.netty.buffer.ByteBuf;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2371;
import net.minecraft.class_2480;
import net.minecraft.class_2561;
import net.minecraft.class_3542;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9288;
import net.minecraft.class_9334;

public record ShulkerFillLevelAttribute(ShulkerLevels levels) implements ItemAttribute {
    public static final MapCodec<ShulkerFillLevelAttribute> CODEC = ShulkerLevels.CODEC.xmap(
        ShulkerFillLevelAttribute::new,
        ShulkerFillLevelAttribute::levels
    ).fieldOf("value");

    public static final class_9139<ByteBuf, ShulkerFillLevelAttribute> PACKET_CODEC = ShulkerLevels.STREAM_CODEC.method_56432(
        ShulkerFillLevelAttribute::new,
        ShulkerFillLevelAttribute::levels
    );

    @Override
    public boolean appliesTo(class_1799 stack, class_1937 level) {
        return levels != null && levels.canApply(stack);
    }

    @Override
    public String getTranslationKey() {
        return "shulker_level";
    }

    @Override
    public Object[] getTranslationParameters() {
        String parameter = "";
        if (levels != null)
            parameter = class_2561.method_43471("create.item_attributes." + getTranslationKey() + "." + levels.key).getString();
        return new Object[]{parameter};
    }

    @Override
    public ItemAttributeType getType() {
        return AllItemAttributeTypes.SHULKER_FILL_LEVEL;
    }

    enum ShulkerLevels implements class_3542 {
        EMPTY("empty", amount -> amount == 0),
        PARTIAL("partial", amount -> amount > 0 && amount < Integer.MAX_VALUE),
        FULL("full", amount -> amount == Integer.MAX_VALUE);

        public static final Codec<ShulkerLevels> CODEC = class_3542.method_28140(ShulkerLevels::values);
        public static final class_9139<ByteBuf, ShulkerLevels> STREAM_CODEC = CatnipStreamCodecBuilders.ofEnum(ShulkerLevels.class);

        private final Predicate<Integer> requiredSize;
        private final String key;

        ShulkerLevels(String key, Predicate<Integer> requiredSize) {
            this.key = key;
            this.requiredSize = requiredSize;
        }

        @Nullable
        public static ShulkerFillLevelAttribute.ShulkerLevels fromKey(String key) {
            return Arrays.stream(values()).filter(shulkerLevels -> shulkerLevels.key.equals(key)).findFirst().orElse(null);
        }

        private static boolean isShulker(class_1799 stack) {
            return class_2248.method_9503(stack.method_7909()) instanceof class_2480;
        }

        @Override
        public String method_15434() {
            return name().toLowerCase(Locale.ROOT);
        }

        public boolean canApply(class_1799 testStack) {
            if (!isShulker(testStack))
                return false;
            class_9288 contents = testStack.method_58695(class_9334.field_49622, class_9288.field_49334);
            if (contents == class_9288.field_49334)
                return requiredSize.test(0);
            if (testStack.method_57826(class_9334.field_49626))
                return false;
            if (!contents.field_49338.isEmpty()) {
                int rawSize = contents.field_49338.size();
                if (rawSize < 27)
                    return requiredSize.test(rawSize);

                class_2371<class_1799> inventory = class_2371.method_10213(27, class_1799.field_8037);
                contents.method_57492(inventory);
                boolean isFull = inventory.stream().allMatch(itemStack -> !itemStack.method_7960() && itemStack.method_7947() == itemStack.method_7914());
                return requiredSize.test(isFull ? Integer.MAX_VALUE : rawSize);
            }
            return requiredSize.test(0);
        }
    }

    public static class Type implements ItemAttributeType {
        @Override
        public @NotNull ItemAttribute createAttribute() {
            return new ShulkerFillLevelAttribute(null);
        }

        @Override
        public List<ItemAttribute> getAllAttributes(class_1799 stack, class_1937 level) {
            List<ItemAttribute> list = new ArrayList<>();

            for (ShulkerLevels shulkerLevels : ShulkerLevels.values()) {
                if (shulkerLevels.canApply(stack)) {
                    list.add(new ShulkerFillLevelAttribute(shulkerLevels));
                }
            }

            return list;
        }

        @Override
        public MapCodec<? extends ItemAttribute> codec() {
            return CODEC;
        }

        @Override
        public class_9139<? super class_9129, ? extends ItemAttribute> packetCodec() {
            return PACKET_CODEC;
        }
    }
}
