package com.zurrtum.create.content.logistics.packagePort;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.api.registry.CreateRegistries;
import com.zurrtum.create.api.registry.CreateRegistryKeys;
import com.zurrtum.create.catnip.codecs.stream.CatnipStreamCodecBuilders;
import com.zurrtum.create.content.kinetics.chainConveyor.ChainConveyorBlockEntity;
import com.zurrtum.create.content.kinetics.chainConveyor.ChainConveyorBlockEntity.ConnectedPort;
import com.zurrtum.create.content.kinetics.chainConveyor.ChainConveyorBlockEntity.ConnectionStats;
import com.zurrtum.create.content.kinetics.chainConveyor.ChainConveyorPackage;
import com.zurrtum.create.content.trains.station.StationBlockEntity;
import io.netty.buffer.ByteBuf;
import org.jetbrains.annotations.Nullable;

import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public abstract class PackagePortTarget {
    public static final Codec<PackagePortTarget> CODEC = CreateRegistries.PACKAGE_PORT_TARGET_TYPE.method_39673()
        .dispatch(PackagePortTarget::getType, PackagePortTargetType::codec);
    public static final class_9139<? super class_9129, PackagePortTarget> PACKET_CODEC = class_9135.method_56365(CreateRegistryKeys.PACKAGE_PORT_TARGET_TYPE)
        .method_56440(PackagePortTarget::getType, PackagePortTargetType::packetCodec);

    public class_2338 relativePos;

    public PackagePortTarget(class_2338 relativePos) {
        this.relativePos = relativePos;
    }

    public abstract boolean export(class_1936 level, class_2338 portPos, class_1799 box, boolean simulate);

    public void setup(PackagePortBlockEntity ppbe, class_1936 level, class_2338 portPos) {
    }

    public void register(PackagePortBlockEntity ppbe, class_1936 level, class_2338 portPos) {
    }

    public void deregister(PackagePortBlockEntity ppbe, class_1936 level, class_2338 portPos) {
    }

    public abstract class_243 getExactTargetLocation(PackagePortBlockEntity ppbe, class_1936 level, class_2338 portPos);

    public abstract class_1799 getIcon();

    public abstract boolean canSupport(class_2586 be);

    public boolean depositImmediately() {
        return false;
    }

    protected abstract PackagePortTargetType getType();

    public class_2586 be(class_1936 level, class_2338 portPos) {
        if (level instanceof class_1937 l && !l.method_8477(portPos.method_10081(relativePos)))
            return null;
        return level.method_8321(portPos.method_10081(relativePos));
    }

    public static class ChainConveyorFrogportTarget extends PackagePortTarget {
        public static final MapCodec<ChainConveyorFrogportTarget> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(
            class_2338.field_25064.fieldOf("relative_pos").forGetter(i -> i.relativePos),
            Codec.FLOAT.fieldOf("chain_pos").forGetter(i -> i.chainPos),
            class_2338.field_25064.optionalFieldOf("connection").forGetter(i -> Optional.ofNullable(i.connection)),
            Codec.BOOL.fieldOf("flipped").forGetter(i -> i.flipped)
        ).apply(instance, ChainConveyorFrogportTarget::new));

        public static final class_9139<ByteBuf, ChainConveyorFrogportTarget> PACKET_CODEC = class_9139.method_56905(
            class_2338.field_48404,
            i -> i.relativePos,
            class_9135.field_48552,
            i -> i.chainPos,
            CatnipStreamCodecBuilders.nullable(class_2338.field_48404),
            i -> i.connection,
            class_9135.field_48547,
            i -> i.flipped,
            ChainConveyorFrogportTarget::new
        );

        public float chainPos;
        @Nullable
        public class_2338 connection;
        public boolean flipped;

        public ChainConveyorFrogportTarget(class_2338 relativePos, float chainPos, Optional<class_2338> connection, boolean flipped) {
            this(relativePos, chainPos, connection.orElse(null), flipped);
        }

        public ChainConveyorFrogportTarget(class_2338 relativePos, float chainPos, @Nullable class_2338 connection, boolean flipped) {
            super(relativePos);
            this.chainPos = chainPos;
            this.connection = connection;
            this.flipped = flipped;
        }

        @Override
        public void setup(PackagePortBlockEntity ppbe, class_1936 level, class_2338 portPos) {
            if (be(level, portPos) instanceof ChainConveyorBlockEntity clbe)
                flipped = clbe.getSpeed() < 0;
        }

        @Override
        public class_1799 getIcon() {
            return AllItems.CHAIN_CONVEYOR.method_7854();
        }

        @Override
        public boolean export(class_1936 level, class_2338 portPos, class_1799 box, boolean simulate) {
            if (!(be(level, portPos) instanceof ChainConveyorBlockEntity clbe))
                return false;
            if (connection != null && !clbe.connections.contains(connection))
                return false;
            if (simulate)
                return clbe.getSpeed() != 0 && clbe.canAcceptPackagesFor(connection);
            ChainConveyorPackage box2 = new ChainConveyorPackage(chainPos, box.method_7972());
            if (connection == null)
                return clbe.addLoopingPackage(box2);
            return clbe.addTravellingPackage(box2, connection);
        }

        @Override
        public void register(PackagePortBlockEntity ppbe, class_1936 level, class_2338 portPos) {
            if (!(be(level, portPos) instanceof ChainConveyorBlockEntity clbe))
                return;
            ChainConveyorBlockEntity actualBe = clbe;

            // Jump to opposite chain if motion reversed
            if (connection != null && clbe.getSpeed() < 0 != flipped) {
                deregister(ppbe, level, portPos);
                actualBe = AllBlocks.CHAIN_CONVEYOR.getBlockEntity(level, clbe.method_11016().method_10081(connection));
                if (actualBe == null)
                    return;
                clbe.prepareStats();
                ConnectionStats stats = clbe.connectionStats.get(connection);
                if (stats != null)
                    chainPos = stats.chainLength() - chainPos;
                connection = connection.method_35830(-1);
                flipped = !flipped;
                relativePos = actualBe.method_11016().method_10059(portPos);
                ppbe.notifyUpdate();
            }

            if (connection != null && !actualBe.connections.contains(connection))
                return;
            String portFilter = ppbe.getFilterString();
            if (portFilter == null)
                return;
            actualBe.routingTable.receivePortInfo(portFilter, connection == null ? class_2338.field_10980 : connection);
            Map<class_2338, ConnectedPort> portMap = connection == null ? actualBe.loopPorts : actualBe.travelPorts;
            portMap.put(relativePos.method_35830(-1), new ConnectedPort(chainPos, connection, portFilter));
        }

        @Override
        public void deregister(PackagePortBlockEntity ppbe, class_1936 level, class_2338 portPos) {
            if (!(be(level, portPos) instanceof ChainConveyorBlockEntity clbe))
                return;
            clbe.loopPorts.remove(relativePos.method_35830(-1));
            clbe.travelPorts.remove(relativePos.method_35830(-1));
            String portFilter = ppbe.getFilterString();
            if (portFilter == null)
                return;
            clbe.routingTable.entriesByDistance.removeIf(e -> e.endOfRoute() && e.port().equals(portFilter));
            clbe.routingTable.changed = true;
        }

        @Override
        public class_243 getExactTargetLocation(PackagePortBlockEntity ppbe, class_1936 level, class_2338 portPos) {
            if (!(be(level, portPos) instanceof ChainConveyorBlockEntity clbe))
                return class_243.field_1353;
            return clbe.getPackagePosition(chainPos, connection);
        }

        @Override
        public boolean canSupport(class_2586 be) {
            return be.method_11017() == AllBlockEntityTypes.PACKAGE_FROGPORT;
        }

        @Override
        protected PackagePortTargetType getType() {
            return AllPackagePortTargetTypes.CHAIN_CONVEYOR;
        }

        public static class Type implements PackagePortTargetType {
            @Override
            public MapCodec<ChainConveyorFrogportTarget> codec() {
                return CODEC;
            }

            @Override
            public class_9139<ByteBuf, ChainConveyorFrogportTarget> packetCodec() {
                return PACKET_CODEC;
            }
        }
    }

    public static class TrainStationFrogportTarget extends PackagePortTarget {
        public static MapCodec<TrainStationFrogportTarget> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(class_2338.field_25064.fieldOf(
            "relative_pos").forGetter(i -> i.relativePos)).apply(instance, TrainStationFrogportTarget::new));

        public static final class_9139<ByteBuf, TrainStationFrogportTarget> PACKET_CODEC = class_2338.field_48404.method_56432(
            TrainStationFrogportTarget::new,
            i -> i.relativePos
        );

        public TrainStationFrogportTarget(class_2338 relativePos) {
            super(relativePos);
        }

        @Override
        public class_1799 getIcon() {
            return AllItems.TRACK_STATION.method_7854();
        }

        @Override
        public boolean export(class_1936 level, class_2338 portPos, class_1799 box, boolean simulate) {
            return false;
        }

        @Override
        public class_243 getExactTargetLocation(PackagePortBlockEntity ppbe, class_1936 level, class_2338 portPos) {
            return class_243.method_24953(portPos.method_10081(relativePos));
        }

        @Override
        public void register(PackagePortBlockEntity ppbe, class_1936 level, class_2338 portPos) {
            if (be(level, portPos) instanceof StationBlockEntity sbe)
                sbe.attachPackagePort(ppbe);
        }

        @Override
        public void deregister(PackagePortBlockEntity ppbe, class_1936 level, class_2338 portPos) {
            if (be(level, portPos) instanceof StationBlockEntity sbe)
                sbe.removePackagePort(ppbe);
        }

        @Override
        public boolean depositImmediately() {
            return true;
        }

        @Override
        public boolean canSupport(class_2586 be) {
            return be.method_11017() == AllBlockEntityTypes.PACKAGE_POSTBOX;
        }

        @Override
        protected PackagePortTargetType getType() {
            return AllPackagePortTargetTypes.TRAIN_STATION;
        }

        public static class Type implements PackagePortTargetType {
            @Override
            public MapCodec<TrainStationFrogportTarget> codec() {
                return CODEC;
            }

            @Override
            public class_9139<ByteBuf, TrainStationFrogportTarget> packetCodec() {
                return PACKET_CODEC;
            }
        }
    }
}
