package com.zurrtum.create.content.logistics.packagePort.frogport;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.animation.LerpedFloat.Chaser;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.content.logistics.box.PackageItem;
import com.zurrtum.create.content.logistics.box.PackageStyles;
import com.zurrtum.create.content.logistics.packagePort.PackagePortBlockEntity;
import com.zurrtum.create.content.logistics.packager.PackagerItemHandler;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.behaviour.audio.FrogportAudioBehaviour;
import com.zurrtum.create.foundation.item.ItemHelper;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2388;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.util.math.*;

import java.util.List;

public class FrogportBlockEntity extends PackagePortBlockEntity {

    public class_1799 animatedPackage;
    public LerpedFloat manualOpenAnimationProgress;
    public LerpedFloat animationProgress;
    public LerpedFloat anticipationProgress;
    public boolean currentlyDepositing;
    public boolean goggles;

    public boolean sendAnticipate;

    public float passiveYaw;

    public boolean failedLastExport;

    private class_1799 deferAnimationStart;
    private boolean deferAnimationInward;

    //TODO
    //    public AbstractComputerBehaviour computerBehaviour;

    public FrogportBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.PACKAGE_FROGPORT, pos, state);
        animationProgress = LerpedFloat.linear();
        anticipationProgress = LerpedFloat.linear();
        manualOpenAnimationProgress = LerpedFloat.linear().startWithValue(0).chase(0, 0.35, Chaser.LINEAR);
        goggles = false;
    }

    //TODO
    //    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
    //        if (Mods.COMPUTERCRAFT.isLoaded()) {
    //            event.registerBlockEntity(
    //                PeripheralCapability.get(),
    //                AllBlockEntityTypes.PACKAGE_FROGPORT.get(),
    //                (be, context) -> be.computerBehaviour.getPeripheralCapability()
    //            );
    //        }
    //    }

    //TODO
    //    @Override
    //    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
    //        behaviours.add(computerBehaviour = ComputerCraftProxy.behaviour(this));
    //        super.addBehaviours(behaviours);
    //    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.FROGPORT);
    }

    public boolean isAnimationInProgress() {
        return animationProgress.getChaseTarget() == 1;
    }

    @Override
    public class_238 getRenderBoundingBox() {
        class_238 bb = super.getRenderBoundingBox().method_1012(0, 1, 0);
        if (target != null)
            bb = bb.method_991(new class_238(class_2338.method_49638(target.getExactTargetLocation(this, field_11863, field_11867)))).method_1014(0.5);
        return bb;
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (field_11863.method_8608() || isAnimationInProgress())
            return;

        boolean prevFail = failedLastExport;
        tryPushingToAdjacentInventories();
        tryPullingFromOwnAndAdjacentInventories();

        if (failedLastExport != prevFail)
            sendData();
    }

    public void sendAnticipate() {
        if (isAnimationInProgress())
            return;
        for (int i = 0, size = inventory.method_5439(); i < size; i++)
            if (inventory.method_5438(i).method_7960()) {
                sendAnticipate = true;
                sendData();
                return;
            }
    }

    public void anticipate() {
        anticipationProgress.chase(1, 0.1, Chaser.LINEAR);
    }

    @Override
    public void tick() {
        super.tick();

        if (deferAnimationStart != null) {
            startAnimation(deferAnimationStart, deferAnimationInward);
            deferAnimationStart = null;
        }

        if (anticipationProgress.getValue() == 1)
            anticipationProgress.startWithValue(0);

        manualOpenAnimationProgress.updateChaseTarget(openTracker.openCount > 0 ? 1 : 0);
        boolean wasOpen = manualOpenAnimationProgress.getValue() > 0;

        anticipationProgress.tickChaser();
        manualOpenAnimationProgress.tickChaser();

        if (field_11863.method_8608() && wasOpen && manualOpenAnimationProgress.getValue() == 0)
            getBehaviour(FrogportAudioBehaviour.TYPE).close(field_11863, field_11867);

        if (!isAnimationInProgress())
            return;

        animationProgress.tickChaser();

        float value = animationProgress.getValue();
        if (currentlyDepositing) {
            if (!field_11863.method_8608() || isVirtual()) {
                if (value > 0.5 && animatedPackage != null) {
                    if (target == null || !target.depositImmediately() && !target.export(field_11863, field_11867, animatedPackage, false))
                        drop(animatedPackage);
                    animatedPackage = null;
                }
            } else {
                if (value > 0.7 && animatedPackage != null)
                    animatedPackage = null;
                if (animationProgress.getValue(0) < 0.2 && value > 0.2) {
                    class_243 v = target.getExactTargetLocation(this, field_11863, field_11867);
                    field_11863.method_8486(v.field_1352, v.field_1351, v.field_1350, class_3417.field_24064, class_3419.field_15245, 0.25f, 1.2f, false);
                }
            }
        }

        if (value < 1)
            return;

        anticipationProgress.startWithValue(0);
        animationProgress.startWithValue(0);
        if (field_11863.method_8608()) {
            //			sounds.close(level, worldPosition);
            animatedPackage = null;
            return;
        }

        if (!currentlyDepositing) {
            int count = animatedPackage.method_7947();
            inventory.sendMode();
            int insert = inventory.insert(animatedPackage, count);
            inventory.receiveMode();
            if (insert != count) {
                if (insert == 0) {
                    drop(animatedPackage);
                } else {
                    drop(animatedPackage.method_46651(count - insert));
                }
            }
        }

        animatedPackage = null;
    }

    public void startAnimation(class_1799 box, boolean deposit) {
        if (!PackageItem.isPackage(box))
            return;

        if (deposit && (target == null || target.depositImmediately() && !target.export(field_11863, field_11867, box.method_7972(), false)))
            return;

        animationProgress.startWithValue(0);
        animationProgress.chase(1, 0.1, Chaser.LINEAR);
        animatedPackage = box;
        currentlyDepositing = deposit;

        if (field_11863 != null && !deposit && !field_11863.method_8608())
            award(AllAdvancements.FROGPORT);

        if (field_11863 != null && field_11863.method_8608()) {
            FrogportAudioBehaviour sounds = getBehaviour(FrogportAudioBehaviour.TYPE);
            sounds.open(field_11863, field_11867);

            if (currentlyDepositing) {
                sounds.depositPackage(field_11863, field_11867);

            } else {
                sounds.catchPackage(field_11863, field_11867);
                class_243 vec = target.getExactTargetLocation(this, field_11863, field_11867);
                if (vec != null)
                    for (int i = 0; i < 5; i++)
                        field_11863.method_8406(
                            new class_2388(class_2398.field_11217, AllBlocks.ROPE.method_9564()),
                            vec.field_1352,
                            vec.field_1351 - field_11863.field_9229.method_43057() * 0.25,
                            vec.field_1350,
                            0,
                            0,
                            0
                        );
            }
        }

        if (field_11863 != null && !field_11863.method_8608()) {
            field_11863.method_8524(field_11867);
            sendData();
        }
    }

    protected void tryPushingToAdjacentInventories() {
        failedLastExport = false;
        if (inventory.method_5442())
            return;
        class_1263 handler = getAdjacentInventory(class_2350.field_11033);
        if (handler == null)
            return;

        boolean dirty = false;
        for (int i = 0, size = inventory.method_5439(); i < size; i++) {
            class_1799 stack = inventory.method_5438(i);
            if (inventory.method_5493(i, stack, null)) {
                int insert = handler.insertExist(stack, 1);
                if (insert == 1) {
                    int count = stack.method_7947();
                    if (count == insert) {
                        inventory.method_5447(i, class_1799.field_8037);
                    } else {
                        stack.method_7939(count - 1);
                    }
                    dirty = true;
                } else {
                    failedLastExport = true;
                }
            }
        }
        if (dirty) {
            inventory.method_5431();
            field_11863.method_8524(field_11867);
        }
    }

    @Override
    protected void onOpenChange(boolean open) {
    }

    public void tryPullingFromOwnAndAdjacentInventories() {
        if (isAnimationInProgress())
            return;
        if (target == null || !target.export(field_11863, field_11867, PackageStyles.getDefaultBox(), true))
            return;
        inventory.sendMode();
        class_1799 stack = inventory.extractAny();
        inventory.receiveMode();
        if (!stack.method_7960()) {
            startAnimation(stack, true);
            return;
        }
        for (class_2350 side : Iterate.directions) {
            if (side != class_2350.field_11033)
                continue;
            class_1263 handler = getAdjacentInventory(side);
            if (handler == null)
                continue;
            if (tryPullingFrom(handler))
                return;
        }
    }

    public boolean tryPullingFrom(class_1263 handler) {
        class_1799 extract = handler.extract(stack -> {
            if (!PackageItem.isPackage(stack))
                return false;
            String filterString = getFilterString();
            return filterString == null || handler instanceof PackagerItemHandler || !PackageItem.matchAddress(stack, filterString);
        });
        if (extract.method_7960())
            return false;
        startAnimation(extract, true);
        return true;

    }

    protected class_1263 getAdjacentInventory(class_2350 side) {
        class_2338 pos = this.field_11867.method_10093(side);
        class_2586 blockEntity = field_11863.method_8321(pos);
        if (blockEntity == null || blockEntity instanceof FrogportBlockEntity)
            return null;
        return ItemHelper.getInventory(field_11863, pos, null, blockEntity, side.method_10153());
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);
        view.method_71464("PlacedYaw", passiveYaw);
        if (animatedPackage != null && isAnimationInProgress()) {
            view.method_71468("AnimatedPackage", class_1799.field_24671, animatedPackage);
            view.method_71472("Deposit", currentlyDepositing);
        }
        if (sendAnticipate) {
            sendAnticipate = false;
            view.method_71472("Anticipate", true);
        }
        if (failedLastExport)
            view.method_71472("FailedLastExport", true);
        if (goggles)
            view.method_71472("Goggles", true);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        passiveYaw = view.method_71423("PlacedYaw", 0);
        failedLastExport = view.method_71433("FailedLastExport", false);
        goggles = view.method_71433("Goggles", false);
        if (!clientPacket)
            animatedPackage = null;
        view.method_71426("AnimatedPackage", class_1799.field_24671).ifPresent(stack -> {
            deferAnimationInward = view.method_71433("Deposit", false);
            deferAnimationStart = stack;
        });
        if (clientPacket && view.method_71433("Anticipate", false))
            anticipate();
    }

    public float getYaw() {
        if (target == null)
            return passiveYaw;
        class_243 diff = target.getExactTargetLocation(this, field_11863, field_11867).method_1020(class_243.method_24953(field_11867));
        return (float) (class_3532.method_15349(diff.field_1352, diff.field_1350) * class_3532.field_29848) + 180;
    }

    @Override
    protected void onOpenedManually() {
        if (field_11863.method_8608())
            getBehaviour(FrogportAudioBehaviour.TYPE).open(field_11863, field_11867);
    }

    @Override
    public class_1269 use(class_1657 player) {
        if (player == null)
            return class_1269.field_52423;

        if (!goggles) {
            class_1799 mainHandItem = player.method_6047();
            if (mainHandItem.method_31574(AllItems.GOGGLES)) {
                goggles = true;
                if (!field_11863.method_8608()) {
                    notifyUpdate();
                    field_11863.method_8396(null, field_11867, class_3417.field_14761.comp_349(), class_3419.field_15245, 0.5f, 1.0f);
                }
                return class_1269.field_5812;
            }
        }

        return super.use(player);
    }

    //TODO
    //    @Override
    //    public void invalidate() {
    //        super.invalidate();
    //        computerBehaviour.removePeripheral();
    //    }

}
