package com.zurrtum.create.content.redstone;

import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.content.equipment.wrench.IWrenchable;
import com.zurrtum.create.content.redstone.diodes.BrassDiodeBlock;
import com.zurrtum.create.foundation.block.WeakPowerControlBlock;
import org.jetbrains.annotations.Nullable;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.class_1269;
import net.minecraft.class_1750;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_3218;
import net.minecraft.class_5819;
import net.minecraft.class_8235;
import net.minecraft.class_9904;

public class RoseQuartzLampBlock extends class_2248 implements IWrenchable, WeakPowerControlBlock {

    public static final class_2746 POWERED = class_2741.field_12484;
    public static final class_2746 POWERING = BrassDiodeBlock.POWERING;
    public static final class_2746 ACTIVATE = class_2746.method_11825("activate");

    public RoseQuartzLampBlock(class_2251 p_49795_) {
        super(p_49795_);
        method_9590(method_9564().method_11657(POWERED, false).method_11657(POWERING, false).method_11657(ACTIVATE, false));
    }

    @Override
    public class_2680 method_9605(class_1750 pContext) {
        class_2680 stateForPlacement = super.method_9605(pContext);
        return stateForPlacement.method_11657(POWERED, pContext.method_8045().method_49803(pContext.method_8037()));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> pBuilder) {
        super.method_9515(pBuilder.method_11667(POWERED, POWERING, ACTIVATE));
    }

    @Override
    public boolean shouldCheckWeakPower(class_2680 state, class_8235 level, class_2338 pos, class_2350 side) {
        return false;
    }

    @Override
    public void method_9612(
        class_2680 pState,
        class_1937 pLevel,
        class_2338 pPos,
        class_2248 pBlock,
        @Nullable class_9904 wireOrientation,
        boolean pIsMoving
    ) {
        if (pLevel.method_8608())
            return;

        boolean isPowered = pState.method_11654(POWERED);
        if (isPowered == pLevel.method_49803(pPos))
            return;
        if (isPowered) {
            pLevel.method_8652(pPos, pState.method_28493(POWERED), class_2248.field_31028);
            return;
        }

        forEachInCluster(
            pLevel, pPos, (currentPos, currentState) -> {
                pLevel.method_8652(currentPos, currentState.method_11657(POWERING, false), class_2248.field_31028);
                scheduleActivation(pLevel, currentPos);
            }
        );

        pLevel.method_8652(pPos, pState.method_11657(POWERED, true).method_11657(POWERING, true).method_11657(ACTIVATE, true), class_2248.field_31028);
        pLevel.method_8452(pPos, this, null);
        scheduleActivation(pLevel, pPos);
    }

    private void scheduleActivation(class_1937 pLevel, class_2338 pPos) {
        if (!pLevel.method_8397().method_8674(pPos, this))
            pLevel.method_64310(pPos, this, 1);
    }

    private void forEachInCluster(class_1937 pLevel, class_2338 pPos, BiConsumer<class_2338, class_2680> callback) {
        List<class_2338> frontier = new LinkedList<>();
        Set<class_2338> visited = new HashSet<>();
        frontier.add(pPos);
        visited.add(pPos);

        while (!frontier.isEmpty()) {
            class_2338 pos = frontier.removeFirst();
            for (class_2350 d : Iterate.directions) {
                class_2338 currentPos = pos.method_10093(d);
                if (currentPos.method_19455(pPos) > 16)
                    continue;
                if (!visited.add(currentPos))
                    continue;
                class_2680 currentState = pLevel.method_8320(currentPos);
                if (!currentState.method_27852(this))
                    continue;
                callback.accept(currentPos, currentState);
                frontier.add(currentPos);
            }
        }
    }

    @Override
    public boolean method_9506(class_2680 pState) {
        return true;
    }

    @Override
    public int method_9524(class_2680 pState, class_1922 pLevel, class_2338 pPos, class_2350 pDirection) {
        if (pDirection == null)
            return 0;
        class_2680 toState = pLevel.method_8320(pPos.method_10093(pDirection.method_10153()));
        if (toState.method_27852(this))
            return 0;
        if (toState.method_27852(class_2246.field_10377))
            return getDistanceToPowered(pLevel, pPos, pDirection);
        //		if (toState.is(Blocks.REDSTONE_WIRE))
        //			return 0;
        return pState.method_11654(POWERING) ? 15 : 0;
    }

    private int getDistanceToPowered(class_1922 level, class_2338 pos, class_2350 column) {
        class_2338.class_2339 currentPos = pos.method_25503();
        for (int power = 15; power > 0; power--) {
            class_2680 blockState = level.method_8320(currentPos);
            if (!blockState.method_27852(this))
                return 0;
            if (blockState.method_11654(POWERING))
                return power;
            currentPos.method_10098(column);
        }
        return 0;
    }

    @Override
    public void method_9588(class_2680 pState, class_3218 pLevel, class_2338 pPos, class_5819 pRand) {
        boolean wasPowering = pState.method_11654(POWERING);
        boolean shouldBePowering = pState.method_11654(ACTIVATE);

        if (wasPowering || shouldBePowering) {
            pLevel.method_8652(pPos, pState.method_11657(ACTIVATE, false).method_11657(POWERING, shouldBePowering), class_2248.field_31028);
        }

        pLevel.method_8452(pPos, this, null);
    }

    @Override
    public class_2680 getRotatedBlockState(class_2680 originalState, class_2350 targetedFace) {
        return originalState.method_28493(POWERING);
    }

    @Override
    public class_1269 onWrenched(class_2680 state, class_1838 context) {
        class_1269 onWrenched = IWrenchable.super.onWrenched(state, context);
        if (!onWrenched.method_23665())
            return onWrenched;

        forEachInCluster(
            context.method_8045(),
            context.method_8037(),
            (currentPos, currentState) -> context.method_8045().method_8452(currentPos, this, null)
        );
        return onWrenched;
    }

}
