package com.zurrtum.create.content.redstone.link.controller;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.content.redstone.link.RedstoneLinkNetworkHandler.Frequency;
import com.zurrtum.create.foundation.gui.menu.MenuBase;
import com.zurrtum.create.foundation.gui.menu.MenuProvider;
import com.zurrtum.create.foundation.item.ItemHelper;
import com.zurrtum.create.infrastructure.items.ItemStackHandler;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3715;
import net.minecraft.class_3965;
import net.minecraft.class_9129;
import net.minecraft.class_9288;
import org.jetbrains.annotations.Nullable;

public class LinkedControllerItem extends class_1792 implements MenuProvider {

    public LinkedControllerItem(class_1793 properties) {
        super(properties);
    }

    public static class_1269 onItemUseFirst(class_1937 world, class_1657 player, class_1799 stack, class_1268 hand, class_3965 ray, class_2338 pos) {
        if (stack.method_7909() instanceof LinkedControllerItem item) {
            if (player.method_7294()) {
                class_2680 hitState = world.method_8320(pos);
                if (player.method_5715()) {
                    if (hitState.method_27852(AllBlocks.LECTERN_CONTROLLER)) {
                        if (!world.method_8608())
                            AllBlocks.LECTERN_CONTROLLER.withBlockEntityDo(world, pos, be -> be.swapControllers(stack, player, hand, hitState));
                        return class_1269.field_5812;
                    }
                } else {
                    if (hitState.method_27852(AllBlocks.REDSTONE_LINK)) {
                        if (world.method_8608())
                            AllClientHandle.INSTANCE.toggleLinkedControllerBindMode(pos);
                        player.method_7357().method_62835(stack, 2);
                        return class_1269.field_5812;
                    }

                    if (hitState.method_27852(class_2246.field_16330) && !hitState.method_11654(class_3715.field_17366)) {
                        if (!world.method_8608()) {
                            class_1799 lecternStack = player.method_68878() ? stack.method_7972() : stack.method_7971(1);
                            AllBlocks.LECTERN_CONTROLLER.replaceLectern(hitState, world, pos, lecternStack);
                        }
                        return class_1269.field_5812;
                    }

                    if (hitState.method_27852(AllBlocks.LECTERN_CONTROLLER))
                        return class_1269.field_5811;
                }
            }

            return item.method_7836(world, player, hand);
        }
        return null;
    }

    @Override
    public class_1269 method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 heldItem = player.method_5998(hand);

        if (player.method_5715() && hand == class_1268.field_5808) {
            if (!world.method_8608() && player instanceof class_3222 serverPlayer && player.method_7294())
                openHandledScreen(serverPlayer);
            return class_1269.field_5812;
        }

        if (!player.method_5715()) {
            if (world.method_8608())
                AllClientHandle.INSTANCE.toggleLinkedControllerActive();
            player.method_7357().method_62835(heldItem, 2);
        }

        return class_1269.field_5811;
    }

    public static ItemStackHandler getFrequencyItems(class_1799 stack) {
        ItemStackHandler newInv = new ItemStackHandler(12);
        if (!stack.method_31574(AllItems.LINKED_CONTROLLER))
            throw new IllegalArgumentException("Cannot get frequency items from non-controller: " + stack);
        if (!stack.method_57826(AllDataComponents.LINKED_CONTROLLER_ITEMS))
            return newInv;
        ItemHelper.fillItemStackHandler(stack.method_58695(AllDataComponents.LINKED_CONTROLLER_ITEMS, class_9288.field_49334), newInv);
        return newInv;
    }

    public static Couple<Frequency> toFrequency(class_1799 controller, int slot) {
        ItemStackHandler frequencyItems = getFrequencyItems(controller);
        return Couple.create(Frequency.of(frequencyItems.method_5438(slot * 2)), Frequency.of(frequencyItems.method_5438(slot * 2 + 1)));
    }

    @Override
    public @Nullable MenuBase<?> createMenu(int id, class_1661 inv, class_1657 player, class_9129 extraData) {
        class_1799 heldItem = player.method_6047();
        class_1799.field_48349.encode(extraData, heldItem);
        return new LinkedControllerMenu(id, inv, heldItem);
    }

    @Override
    public class_2561 getDisplayName() {
        return method_63680();
    }
}
