package com.zurrtum.create.content.redstone.rail;

import com.mojang.serialization.MapCodec;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.equipment.wrench.IWrenchable;
import com.zurrtum.create.foundation.block.MinecartPassBlock;
import net.minecraft.block.*;
import net.minecraft.class_1269;
import net.minecraft.class_1688;
import net.minecraft.class_1696;
import net.minecraft.class_1750;
import net.minecraft.class_1838;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2241;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2350.class_2352;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2457;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_2768;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.state.property.*;
import net.minecraft.util.math.*;
import org.jetbrains.annotations.Nullable;

public class ControllerRailBlock extends class_2241 implements IWrenchable, MinecartPassBlock {

    public static final class_2754<class_2768> SHAPE = class_2741.field_12542;
    public static final class_2746 BACKWARDS = class_2746.method_11825("backwards");
    public static final class_2758 POWER = class_2741.field_12511;
    private static final class_2470[] WRENCH_ROTATION = new class_2470[]{class_2470.field_11463, class_2470.field_11464, class_2470.field_11465};

    public static final MapCodec<ControllerRailBlock> field_46280 = method_54094(ControllerRailBlock::new);

    public ControllerRailBlock(class_2251 properties) {
        super(true, properties);
        method_9590(method_9564().method_11657(POWER, 0).method_11657(BACKWARDS, false).method_11657(SHAPE, class_2768.field_12665).method_11657(field_27096, false));
    }

    public static int getWireColor(class_2680 state, @Nullable class_1920 world, @Nullable class_2338 pos, int tintIndex) {
        return class_2457.method_10487(pos != null && world != null ? state.method_11654(class_2741.field_12511) : 0);
    }

    public static class_2382 getAccelerationVector(class_2680 state) {
        class_2350 pointingTo = getPointingTowards(state);
        return (isStateBackwards(state) ? pointingTo.method_10153() : pointingTo).method_62675();
    }

    private static class_2350 getPointingTowards(class_2680 state) {
        return switch (state.method_11654(SHAPE)) {
            case field_12666, field_12674 -> class_2350.field_11039;
            case field_12667 -> class_2350.field_11034;
            case field_12668 -> class_2350.field_11035;
            default -> class_2350.field_11043;
        };
    }

    @Override
    protected class_2680 method_9475(class_1937 world, class_2338 pos, class_2680 state, boolean p_208489_4_) {
        class_2680 updatedState = super.method_9475(world, pos, state, p_208489_4_);
        if (updatedState.method_11654(SHAPE) == state.method_11654(SHAPE))
            return updatedState;
        class_2680 reversedUpdatedState = updatedState;

        // Rails snapping to others at 90 degrees should follow their direction
        if (getPointingTowards(state).method_10166() != getPointingTowards(updatedState).method_10166()) {
            for (boolean opposite : Iterate.trueAndFalse) {
                class_2350 offset = getPointingTowards(updatedState);
                if (opposite)
                    offset = offset.method_10153();
                for (class_2338 adjPos : Iterate.hereBelowAndAbove(pos.method_10093(offset))) {
                    class_2680 adjState = world.method_8320(adjPos);
                    if (!adjState.method_27852(AllBlocks.CONTROLLER_RAIL))
                        continue;
                    if (getPointingTowards(adjState).method_10166() != offset.method_10166())
                        continue;
                    if (adjState.method_11654(BACKWARDS) != reversedUpdatedState.method_11654(BACKWARDS))
                        reversedUpdatedState = reversedUpdatedState.method_28493(BACKWARDS);
                }
            }
        }

        // Replace if changed
        if (reversedUpdatedState != updatedState)
            world.method_8501(pos, reversedUpdatedState);
        return reversedUpdatedState;
    }

    private static void decelerateCart(class_2338 pos, class_1688 cart) {
        class_243 diff = VecHelper.getCenterOf(pos).method_1020(cart.method_73189());
        cart.method_18800(diff.field_1352 / 16f, 0, diff.field_1350 / 16f);

        if (cart instanceof class_1696 fme) {
            fme.field_54300 = class_243.field_1353;
        }
    }

    private static boolean isStableWith(class_2680 testState, class_1922 world, class_2338 pos) {
        return method_16361(world, pos.method_10074()) && (!testState.method_11654(SHAPE).method_11897() || method_16361(world, pos.method_10093(getPointingTowards(testState))));
    }

    @Override
    public class_2680 method_9605(class_1750 p_196258_1_) {
        class_2350 direction = p_196258_1_.method_8042();
        class_2680 base = super.method_9605(p_196258_1_);
        return (base == null ? method_9564() : base).method_11657(BACKWARDS, direction.method_10171() == class_2352.field_11056);
    }

    @Override
    public class_2769<class_2768> method_9474() {
        return SHAPE;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> p_206840_1_) {
        p_206840_1_.method_11667(SHAPE, POWER, BACKWARDS, field_27096);
    }

    @Override
    public void onMinecartPass(class_2680 state, class_1937 world, class_2338 pos, class_1688 cart) {
        if (world.method_8608())
            return;
        class_243 accelerationVec = class_243.method_24954(getAccelerationVector(state));
        double targetSpeed = cart.method_7504((class_3218) world) * state.method_11654(POWER) / 15f;

        if (cart instanceof class_1696 fme) {
            fme.field_54300 = new class_243(accelerationVec.field_1352, 0, accelerationVec.field_1350);
        }

        class_243 motion = cart.method_18798();
        if ((motion.method_1026(accelerationVec) >= 0 || motion.method_1027() < 0.0001) && targetSpeed > 0)
            cart.method_18799(accelerationVec.method_1021(targetSpeed));
        else
            decelerateCart(pos, cart);
    }

    @Override
    protected void method_9477(class_2680 state, class_1937 world, class_2338 pos, class_2248 block) {
        int newPower = calculatePower(world, pos);
        if (state.method_11654(POWER) != newPower)
            placeAndNotify(state.method_11657(POWER, newPower), pos, world);
    }

    private int calculatePower(class_1937 world, class_2338 pos) {
        int newPower = world.method_49804(pos);
        if (newPower != 0)
            return newPower;

        int forwardDistance = 0;
        int backwardsDistance = 0;
        class_2338 lastForwardRail = pos;
        class_2338 lastBackwardsRail = pos;
        int forwardPower = 0;
        int backwardsPower = 0;

        for (int i = 0; i < 15; i++) {
            class_2338 testPos = findNextRail(lastForwardRail, world, false);
            if (testPos == null)
                break;
            forwardDistance++;
            lastForwardRail = testPos;
            forwardPower = world.method_49804(testPos);
            if (forwardPower != 0)
                break;
        }
        for (int i = 0; i < 15; i++) {
            class_2338 testPos = findNextRail(lastBackwardsRail, world, true);
            if (testPos == null)
                break;
            backwardsDistance++;
            lastBackwardsRail = testPos;
            backwardsPower = world.method_49804(testPos);
            if (backwardsPower != 0)
                break;
        }

        if (forwardDistance > 8 && backwardsDistance > 8)
            return 0;
        if (backwardsPower == 0 && forwardDistance <= 8)
            return forwardPower;
        if (forwardPower == 0 && backwardsDistance <= 8)
            return backwardsPower;
        if (backwardsPower != 0 && forwardPower != 0)
            return class_3532.method_15384((backwardsPower * forwardDistance + forwardPower * backwardsDistance) / (double) (forwardDistance + backwardsDistance));
        return 0;
    }

    @Override
    public class_1269 onWrenched(class_2680 state, class_1838 context) {
        class_1937 world = context.method_8045();
        if (world.method_8608())
            return class_1269.field_5812;
        class_2338 pos = context.method_8037();
        for (class_2470 testRotation : WRENCH_ROTATION) {
            class_2680 testState = method_9598(state, testRotation);
            if (isStableWith(testState, world, pos)) {
                placeAndNotify(testState, pos, world);
                return class_1269.field_5812;
            }
        }
        class_2680 testState = state.method_11657(BACKWARDS, !state.method_11654(BACKWARDS));
        if (isStableWith(testState, world, pos))
            placeAndNotify(testState, pos, world);
        return class_1269.field_5812;
    }

    private void placeAndNotify(class_2680 state, class_2338 pos, class_1937 world) {
        world.method_8652(pos, state, class_2248.field_31036);
        world.method_8452(pos.method_10074(), this, null);
        if (state.method_11654(SHAPE).method_11897())
            world.method_8452(pos.method_10084(), this, null);
    }

    @Nullable
    private class_2338 findNextRail(class_2338 from, class_1922 world, boolean reversed) {
        class_2680 current = world.method_8320(from);
        if (!(current.method_26204() instanceof ControllerRailBlock))
            return null;
        class_2382 accelerationVec = getAccelerationVector(current);
        class_2338 baseTestPos = reversed ? from.method_10059(accelerationVec) : from.method_10081(accelerationVec);
        for (class_2338 testPos : Iterate.hereBelowAndAbove(baseTestPos)) {
            if (testPos.method_10264() > from.method_10264() && !current.method_11654(SHAPE).method_11897())
                continue;
            class_2680 testState = world.method_8320(testPos);
            if (testState.method_26204() instanceof ControllerRailBlock && getAccelerationVector(testState).equals(accelerationVec))
                return testPos;
        }
        return null;
    }

    @Override
    public boolean method_9498(class_2680 state) {
        return true;
    }

    @Override
    public int method_9572(class_2680 state, class_1937 world, class_2338 pos, class_2350 direction) {
        return state.method_11654(POWER);
    }

    @Override
    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        if (rotation == class_2470.field_11467)
            return state;

        class_2768 railshape = class_2246.field_10425.method_9564().method_11657(SHAPE, state.method_11654(SHAPE)).method_26186(rotation).method_11654(SHAPE);
        state = state.method_11657(SHAPE, railshape);

        if (rotation == class_2470.field_11464 || (getPointingTowards(state).method_10166() == class_2351.field_11051) == (rotation == class_2470.field_11465))
            return state.method_28493(BACKWARDS);

        return state;
    }

    @Override
    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        if (mirror == class_2415.field_11302)
            return state;

        class_2768 railshape = class_2246.field_10425.method_9564().method_11657(SHAPE, state.method_11654(SHAPE)).method_26185(mirror).method_11654(SHAPE);
        state = state.method_11657(SHAPE, railshape);

        if ((getPointingTowards(state).method_10166() == class_2351.field_11051) == (mirror == class_2415.field_11300))
            return state.method_28493(BACKWARDS);

        return state;
    }

    public static boolean isStateBackwards(class_2680 state) {
        return state.method_11654(BACKWARDS) ^ isReversedSlope(state);
    }

    public static boolean isReversedSlope(class_2680 state) {
        return state.method_11654(SHAPE) == class_2768.field_12668 || state.method_11654(SHAPE) == class_2768.field_12667;
    }

    @Override
    protected MapCodec<? extends class_2241> method_53969() {
        return field_46280;
    }
}
