package com.zurrtum.create.content.schematics;

import com.mojang.logging.LogUtils;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.foundation.utility.CreatePaths;
import net.minecraft.class_10712;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2561;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_7924;
import net.minecraft.util.*;
import org.slf4j.Logger;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.function.Consumer;
import java.util.zip.GZIPInputStream;

public class SchematicItem extends class_1792 {

    private static final Logger LOGGER = LogUtils.getLogger();

    public SchematicItem(class_1793 properties) {
        super(properties);
    }

    public static class_1799 create(class_1937 level, String schematic, String owner) {
        class_1799 blueprint = AllItems.SCHEMATIC.method_7854();

        blueprint.method_57379(AllDataComponents.SCHEMATIC_DEPLOYED, false);
        blueprint.method_57379(AllDataComponents.SCHEMATIC_OWNER, owner);
        blueprint.method_57379(AllDataComponents.SCHEMATIC_FILE, schematic);
        blueprint.method_57379(AllDataComponents.SCHEMATIC_ANCHOR, class_2338.field_10980);
        blueprint.method_57379(AllDataComponents.SCHEMATIC_ROTATION, class_2470.field_11467);
        blueprint.method_57379(AllDataComponents.SCHEMATIC_MIRROR, class_2415.field_11302);

        writeSize(level, blueprint);
        return blueprint;
    }

    @Override
    @SuppressWarnings("deprecation")
    public void method_67187(
        class_1799 stack,
        class_9635 context,
        class_10712 displayComponent,
        Consumer<class_2561> tooltip,
        class_1836 flagIn
    ) {
        if (stack.method_57826(AllDataComponents.SCHEMATIC_FILE)) {
            tooltip.accept(class_2561.method_43470(class_124.field_1065 + stack.method_58694(AllDataComponents.SCHEMATIC_FILE)));
        } else {
            tooltip.accept(class_2561.method_43471("create.schematic.invalid").method_27692(class_124.field_1061));
        }
        super.method_67187(stack, context, displayComponent, tooltip, flagIn);
    }

    public static void writeSize(class_1937 level, class_1799 blueprint) {
        class_3499 t = loadSchematic(level, blueprint);
        blueprint.method_57379(AllDataComponents.SCHEMATIC_BOUNDS, t.method_15160());
        SchematicInstances.clearHash(blueprint);
    }

    public static class_3492 getSettings(class_1799 blueprint) {
        return getSettings(blueprint, true);
    }

    public static class_3492 getSettings(class_1799 blueprint, boolean processNBT) {
        class_3492 settings = new class_3492();
        settings.method_15123(blueprint.method_58695(AllDataComponents.SCHEMATIC_ROTATION, class_2470.field_11467));
        settings.method_15125(blueprint.method_58695(AllDataComponents.SCHEMATIC_MIRROR, class_2415.field_11302));
        if (processNBT)
            settings.method_16184(SchematicProcessor.INSTANCE);
        return settings;
    }

    public static class_3499 loadSchematic(class_1937 level, class_1799 blueprint) {
        class_3499 t = new class_3499();
        String owner = blueprint.method_58694(AllDataComponents.SCHEMATIC_OWNER);
        String schematic = blueprint.method_58694(AllDataComponents.SCHEMATIC_FILE);

        if (owner == null || schematic == null || !schematic.endsWith(".nbt"))
            return t;

        Path dir;
        Path file;

        if (!level.method_8608()) {
            dir = CreatePaths.UPLOADED_SCHEMATICS_DIR;
            file = Paths.get(owner, schematic);
        } else {
            dir = CreatePaths.SCHEMATICS_DIR;
            file = Paths.get(schematic);
        }

        Path path = dir.resolve(file).normalize();
        if (!path.startsWith(dir))
            return t;

        try (DataInputStream stream = new DataInputStream(new BufferedInputStream(new GZIPInputStream(Files.newInputStream(
            path,
            StandardOpenOption.READ
        ))))) {
            class_2487 nbt = class_2507.method_10625(stream, class_2505.method_53899(0x20000000L));
            t.method_15183(level.method_45448(class_7924.field_41254), nbt);
        } catch (IOException e) {
            LOGGER.warn("Failed to read schematic", e);
        }

        return t;
    }

    @Override
    public class_1269 method_7884(class_1838 context) {
        if (context.method_8036() != null && !onItemUse(context.method_8036(), context.method_20287()))
            return super.method_7884(context);
        return class_1269.field_5812;
    }

    @Override
    public class_1269 method_7836(class_1937 worldIn, class_1657 playerIn, class_1268 handIn) {
        if (!onItemUse(playerIn, handIn))
            return super.method_7836(worldIn, playerIn, handIn);
        return class_1269.field_5812;
    }

    private boolean onItemUse(class_1657 player, class_1268 hand) {
        if (!player.method_5715() || hand != class_1268.field_5808)
            return false;
        if (!player.method_5998(hand).method_57826(AllDataComponents.SCHEMATIC_FILE))
            return false;
        if (!player.method_73183().method_8608())
            return true;
        AllClientHandle.INSTANCE.openSchematicEditScreen();
        return true;
    }
}
