package com.zurrtum.create.content.trains.entity;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_9139;

import static com.zurrtum.create.Create.MOD_ID;

public record TrainIconType(class_2960 id) {
    public static final Codec<TrainIconType> CODEC = class_2960.field_25139.xmap(TrainIconType::byId, TrainIconType::id);
    public static final class_9139<ByteBuf, TrainIconType> STREAM_CODEC = class_2960.field_48267.method_56432(TrainIconType::byId, TrainIconType::id);

    public static final Map<class_2960, TrainIconType> ALL = new HashMap<>();
    public static final TrainIconType TRADITIONAL = register("traditional");
    public static final TrainIconType ELECTRIC = register("electric");
    public static final TrainIconType MODERN = register("modern");

    private static TrainIconType register(String id) {
        TrainIconType type = new TrainIconType(class_2960.method_60655(MOD_ID, id));
        ALL.put(type.id, type);
        return type;
    }

    public static TrainIconType byId(class_2960 id) {
        return ALL.getOrDefault(id, TRADITIONAL);
    }
}
