package com.zurrtum.create.content.trains.entity;

import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_5321;

public class TrainStatus {

    Train train;

    public boolean navigation;
    public boolean track;
    public boolean conductor;

    List<StatusMessage> queued = new ArrayList<>();

    public TrainStatus(Train train) {
        this.train = train;
    }

    public void failedNavigation() {
        if (navigation)
            return;
        displayInformation("no_path", false);
        navigation = true;
    }

    public void failedNavigationNoTarget(String filter) {
        if (navigation)
            return;
        displayInformation("no_match", false, filter);
        navigation = true;
    }

    public void failedPackageNoTarget(String address) {
        if (navigation)
            return;
        displayInformation("no_package_target", false, address);
        navigation = true;
    }

    public void successfulNavigation() {
        if (!navigation)
            return;
        displayInformation("navigation_success", true);
        navigation = false;
    }

    public void foundConductor() {
        if (!conductor)
            return;
        displayInformation("found_driver", true);
        conductor = false;
    }

    public void missingConductor() {
        if (conductor)
            return;
        displayInformation("missing_driver", false);
        conductor = true;
    }

    public void missingCorrectConductor() {
        if (conductor)
            return;
        displayInformation("opposite_driver", false);
        conductor = true;
    }

    public void manualControls() {
        displayInformation("paused_for_manual", true);
    }

    public void failedMigration() {
        if (track)
            return;
        displayInformation("track_missing", false);
        track = true;
    }

    public void highStress() {
        if (track)
            return;
        displayInformation("coupling_stress", false);
        track = true;
    }

    public void doublePortal() {
        if (track)
            return;
        displayInformation("double_portal", false);
        track = true;
    }

    public void endOfTrack() {
        if (track)
            return;
        displayInformation("end_of_track", false);
        track = true;
    }

    public void crash() {
        class_2561 component = class_2561.method_43470(" - ").method_27692(class_124.field_1080)
            .method_10852(class_2561.method_43471("create.train.status.collision").method_54663(0xFFD3B4));
        List<class_5321<class_1937>> presentDimensions = train.getPresentDimensions();
        Stream<class_2561> locationComponents = presentDimensions.stream().map(key -> {
            return class_2561.method_43470(" - ").method_27692(class_124.field_1080).method_10852(class_2561.method_43469(
                "create.train.status.collision.where",
                key.method_29177().toString(),
                train.getPositionInDimension(key).get().method_23854()
            ).method_54663(0xFFD3B4));
        });
        addMessage(new StatusMessage(Streams.concat(Stream.of(component), locationComponents).toArray(class_2561[]::new)));

    }

    public void successfulMigration() {
        if (!track)
            return;
        displayInformation("back_on_track", true);
        track = false;
    }

    public void trackOK() {
        track = false;
    }

    public void tick(class_1937 level) {
        if (queued.isEmpty())
            return;
        class_1309 owner = train.getOwner(level);
        if (owner == null)
            return;
        if (owner instanceof class_1657 player) {
            player.method_7353(class_2561.method_43469("create.train.status", train.name).method_27692(class_124.field_1065), false);
            queued.forEach(message -> message.displayToPlayer(player));
        }
        queued.clear();
    }

    public void displayInformation(String key, boolean itsAGoodThing, Object... args) {
        class_5250 component = class_2561.method_43470(" - ").method_27692(class_124.field_1080)
            .method_10852(class_2561.method_43469("create.train.status." + key, args).method_54663(itsAGoodThing ? 0xD5ECC2 : 0xFFD3B4));
        addMessage(new StatusMessage(component));
    }

    public void addMessage(StatusMessage message) {
        queued.add(message);

        if (queued.size() > 3)
            queued.remove(0);
    }

    public void newSchedule() {
        navigation = false;
        conductor = false;
    }

    public record StatusMessage(class_2561... messages) {
        public void displayToPlayer(class_1657 player) {
            Arrays.stream(messages).forEach(messages -> player.method_7353(messages, false));
        }

    }
}
