package com.zurrtum.create.content.trains.schedule.condition;

import com.mojang.serialization.Codec;
import com.zurrtum.create.Create;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.content.redstone.link.RedstoneLinkNetworkHandler.Frequency;
import com.zurrtum.create.content.trains.entity.Train;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public class RedstoneLinkCondition extends ScheduleWaitCondition {
    private static final Codec<Couple<Frequency>> FREQUENCY_CODEC = Couple.codec(Frequency.CODEC);

    public Couple<Frequency> freq;

    public RedstoneLinkCondition(class_2960 id) {
        super(id);
        freq = Couple.create(() -> Frequency.EMPTY);
    }

    @Override
    public boolean tickCompletion(class_1937 level, Train train, class_2487 context) {
        int lastChecked = context.method_10545("LastChecked") ? context.method_68083("LastChecked", 0) : -1;
        int status = Create.REDSTONE_LINK_NETWORK_HANDLER.globalPowerVersion.get();
        if (status == lastChecked)
            return false;
        context.method_10569("LastChecked", status);
        return Create.REDSTONE_LINK_NETWORK_HANDLER.hasAnyLoadedPower(freq) != lowActivation();
    }

    @Override
    protected void writeAdditional(class_11372 view) {
        view.method_71468("Frequency", FREQUENCY_CODEC, freq);
    }

    public boolean lowActivation() {
        return intData("Inverted") == 1;
    }

    @Override
    protected void readAdditional(class_11368 view) {
        view.method_71426("Frequency", FREQUENCY_CODEC).ifPresent(freq -> this.freq = freq);
    }

    @Override
    public class_5250 getWaitingStatus(class_1937 level, Train train, class_2487 tag) {
        return class_2561.method_43471("create.schedule.condition.redstone_link.status");
    }
}
