package com.zurrtum.create.content.trains.station;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllMapDecorationTypes;
import com.zurrtum.create.content.trains.track.TrackTargetingBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1922;
import net.minecraft.class_20;
import net.minecraft.class_22;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_8824;

public class StationMarker {
    public static final Codec<StationMarker> CODEC = RecordCodecBuilder.create(instance -> instance.group(
        class_2338.field_25064.fieldOf("source").forGetter(StationMarker::getSource),
        class_2338.field_25064.fieldOf("target").forGetter(StationMarker::getTarget),
        class_8824.field_46597.fieldOf("name").forGetter(StationMarker::getName)
    ).apply(instance, StationMarker::new));
    public static final Codec<List<StationMarker>> LIST_CODEC = CODEC.listOf();

    private final class_2338 source;
    private final class_2338 target;
    private final class_2561 name;
    private final String id;

    public StationMarker(class_2338 source, class_2338 target, class_2561 name) {
        this.source = source;
        this.target = target;
        this.name = name;
        id = "create:station-" + target.method_10263() + "," + target.method_10264() + "," + target.method_10260();
    }

    public static StationMarker fromWorld(class_1922 level, class_2338 pos) {
        Optional<StationBlockEntity> stationOption = level.method_35230(pos, AllBlockEntityTypes.TRACK_STATION);

        if (stationOption.isEmpty() || stationOption.get().getStation() == null)
            return null;

        String name = stationOption.get().getStation().name;
        return new StationMarker(
            pos,
            BlockEntityBehaviour.get(stationOption.get(), TrackTargetingBehaviour.TYPE).getPositionForMapMarker(),
            class_2561.method_43470(name)
        );
    }

    public class_2338 getSource() {
        return source;
    }

    public class_2338 getTarget() {
        return target;
    }

    public class_2561 getName() {
        return name;
    }

    public String getId() {
        return id;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o)
            return true;
        if (o == null || getClass() != o.getClass())
            return false;

        StationMarker that = (StationMarker) o;

        if (!target.equals(that.target))
            return false;
        return name.equals(that.name);
    }

    @Override
    public int hashCode() {
        return Objects.hash(target, name);
    }

    public static class_20 createStationDecoration(byte x, byte y, Optional<class_2561> name) {
        return new class_20(AllMapDecorationTypes.STATION_MAP_DECORATION, x, y, (byte) 0, name);
    }

    public record WrapperCodec(Codec<class_22> codec) implements Codec<class_22> {
        private static final String STATION_MARKERS_KEY = "create:stations";
        private static WrapperCodec CODEC;

        public static WrapperCodec get(Codec<class_22> codec) {
            if (CODEC == null) {
                CODEC = new WrapperCodec(codec);
            }
            return CODEC;
        }

        @Override
        public <T> DataResult<Pair<class_22, T>> decode(DynamicOps<T> ops, T input) {
            return codec.decode(ops, input).map(pair -> {
                LIST_CODEC.parse(ops, ops.getMap(input).getOrThrow().get(STATION_MARKERS_KEY))
                    .ifSuccess(list -> list.forEach(((StationMapData) pair.getFirst())::create$addStationMarker));
                return pair;
            });
        }

        @Override
        public <T> DataResult<T> encode(class_22 input, DynamicOps<T> ops, T prefix) {
            return codec.encode(input, ops, prefix).flatMap(result -> {
                RecordBuilder<T> map = ops.mapBuilder();
                map.add(STATION_MARKERS_KEY, ((StationMapData) input).create$getStationMarkers().values().stream().toList(), LIST_CODEC);
                return map.build(result);
            });
        }
    }
}
