package com.zurrtum.create.content.trains.track;

import com.zurrtum.create.Create;
import com.zurrtum.create.api.contraption.train.PortalTrackProvider;
import com.zurrtum.create.catnip.math.BlockFace;
import com.zurrtum.create.content.contraptions.glue.SuperGlueEntity;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_5454;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9797;
import net.minecraft.server.MinecraftServer;

/**
 * Manages portal track integrations for various dimensions and mods within the Create mod.
 * <p>
 * Portals must be entered from the side and must lead to a different dimension than the one entered from.
 * This class handles the registration and functionality of portal tracks for standard and modded portals.
 * </p>
 */
public class AllPortalTracks {
    /**
     * Registers a portal track integration for a given block identified by its {@link class_2960}, if it exists.
     * If it does not, a warning will be logged.
     *
     * @param id       The resource location of the portal block.
     * @param provider The portal track provider for the block.
     */
    public static void tryRegisterIntegration(class_2960 id, PortalTrackProvider provider) {
        if (class_7923.field_41175.method_10250(id)) {
            class_2248 block = class_7923.field_41175.method_63535(id);
            PortalTrackProvider.REGISTRY.register(block, provider);
        } else {
            Create.LOGGER.warn("Portal for integration wasn't found: {}. Compat outdated?", id);
        }
    }

    /**
     * Registers a simple portal track integration for a given block identified by its {@link class_2960}, if it exists.
     * If it does not, a warning will be logged.
     * <p>
     * Note: This only allows registering integrations that go from the Overworld to another dimension and vice versa.
     *
     * @param portalBlockId The resource location of the portal block.
     * @param dimensionId   The resource location of the dimension to travel to
     */
    private static void tryRegisterSimpleInteraction(class_2960 portalBlockId, class_2960 dimensionId) {
        class_5321<class_1937> levelKey = class_5321.method_29179(class_7924.field_41223, dimensionId);
        tryRegisterSimpleInteraction(portalBlockId, levelKey);
    }

    /**
     * Registers a simple portal track integration for a given block identified by its {@link class_2960}, if it exists.
     * If it does not, a warning will be logged.
     * <p>
     * Note: This only allows registering integrations that go from the Overworld to another dimension and vice versa.
     *
     * @param portalBlockId The resource location of the portal block.
     * @param levelKey      The resource key of the dimension to travel to
     */
    private static void tryRegisterSimpleInteraction(class_2960 portalBlockId, class_5321<class_1937> levelKey) {
        tryRegisterSimpleInteraction(class_7923.field_41175.method_63535(portalBlockId), levelKey);
    }

    /**
     * Registers a simple portal track integration for a given block identified by its {@link class_2248}.
     * <p>
     * Note: This only allows registering integrations that go from the Overworld to another dimension and vice versa.
     *
     * @param portalBlock The portal block.
     * @param levelKey    The resource key of the dimension to travel to
     */
    private static void tryRegisterSimpleInteraction(class_2248 portalBlock, class_5321<class_1937> levelKey) {
        PortalTrackProvider p = (level, face) -> PortalTrackProvider.fromPortal(level, face, class_1937.field_25179, levelKey, (class_9797) portalBlock);
        PortalTrackProvider.REGISTRY.register(portalBlock, p);
    }

    // Built-in handlers

    /**
     * Registers default portal track integrations for built-in dimensions and mods.
     * This includes the Nether, the Aether (if loaded) and the end (if betterend is loaded).
     */
    public static void register() {
        tryRegisterSimpleInteraction(class_2246.field_10316, class_1937.field_25180);

        //TODO
        //        if (Mods.AETHER.isLoaded()) {
        //            tryRegisterSimpleInteraction(Mods.AETHER.rl("aether_portal"), Mods.AETHER.rl("the_aether"));
        //        }
        //
        //        if (Mods.AETHER_II.isLoaded()) {
        //            tryRegisterSimpleInteraction(Mods.AETHER_II.rl("aether_portal"), Mods.AETHER_II.rl("aether_highlands"));
        //        }
        //
        //        if (Mods.BETTEREND.isLoaded()) {
        //            tryRegisterSimpleInteraction(Mods.BETTEREND.rl("end_portal_block"), Level.END);
        //        }
    }

    public static PortalTrackProvider.Exit fromPortal(
        class_3218 level,
        BlockFace inboundTrack,
        class_5321<class_1937> firstDimension,
        class_5321<class_1937> secondDimension,
        class_9797 portal
    ) {
        class_5321<class_1937> resourceKey = level.method_27983() == secondDimension ? firstDimension : secondDimension;

        MinecraftServer minecraftServer = level.method_8503();
        class_3218 otherLevel = minecraftServer.method_3847(resourceKey);

        if (otherLevel == null)
            return null;

        class_2338 portalPos = inboundTrack.getConnectedPos();
        class_2680 portalState = level.method_8320(portalPos);

        SuperGlueEntity probe = new SuperGlueEntity(level, new class_238(portalPos));
        probe.method_36456(inboundTrack.getFace().method_10144());

        class_5454 dimensiontransition = portal.method_60770(level, probe, probe.method_24515());
        if (dimensiontransition == null)
            return null;

        if (!minecraftServer.method_74057(dimensiontransition.comp_2820()))
            return null;

        class_2338 otherPortalPos = class_2338.method_49638(dimensiontransition.comp_2821());
        class_2680 otherPortalState = otherLevel.method_8320(otherPortalPos);
        if (!otherPortalState.method_27852(portalState.method_26204()))
            return null;

        class_2350 targetDirection = inboundTrack.getFace();
        if (targetDirection.method_10166() == otherPortalState.method_11654(class_2741.field_12529))
            targetDirection = targetDirection.method_10170();
        class_2338 otherPos = otherPortalPos.method_10093(targetDirection);
        return new PortalTrackProvider.Exit(otherLevel, new BlockFace(otherPos, targetDirection.method_10153()));
    }
}
