package com.zurrtum.create.foundation.blockEntity;

import com.zurrtum.create.foundation.fluid.FluidTank;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import org.jetbrains.annotations.Nullable;

public interface IMultiBlockEntityContainer {

    class_2338 getController();

    <T extends class_2586 & IMultiBlockEntityContainer> T getControllerBE();

    boolean isController();

    void setController(class_2338 pos);

    void removeController(boolean keepContents);

    class_2338 getLastKnownPos();

    void preventConnectivityUpdate();

    void notifyMultiUpdated();

    // only used for FluidTank windows at present. Might be useful for similar properties on other things?
    default void setExtraData(@Nullable Object data) {
    }

    @Nullable
    default Object getExtraData() {
        return null;
    }

    default Object modifyExtraData(Object data) {
        return data;
    }

    // multiblock structural information
    class_2350.class_2351 getMainConnectionAxis();

    default class_2350.class_2351 getMainAxisOf(class_2586 be) { // this feels redundant, but it gives us a default to use when defining ::getMainConnectionAxis
        class_2680 state = be.method_11010();

        class_2350.class_2351 axis;
        if (state.method_28498(class_2741.field_12529)) {
            axis = state.method_11654(class_2741.field_12529);
        } else if (state.method_28498(class_2741.field_12525)) {
            axis = state.method_11654(class_2741.field_12525).method_10166();
        } else if (state.method_28498(class_2741.field_12481)) {
            axis = state.method_11654(class_2741.field_12481).method_10166();
        } else
            axis = class_2350.class_2351.field_11052;

        return axis;
    }

    int getMaxLength(class_2350.class_2351 longAxis, int width);

    int getMaxWidth();

    int getHeight();

    void setHeight(int height);

    int getWidth();

    void setWidth(int width);

    interface Inventory extends IMultiBlockEntityContainer {
        default boolean hasInventory() {
            return false;
        }
    }

    interface Fluid extends IMultiBlockEntityContainer {
        // done here rather than through the Capability to allow greater flexibility
        default boolean hasTank() {
            return false;
        }

        default int getTankSize(int tank) {
            return 0;
        }

        default void setTankSize(int tank, int blocks) {
        }

        default FluidTank getTank(int tank) {
            return null;
        }

        default FluidStack getFluid(int tank) {
            return FluidStack.EMPTY;
        }

        default boolean matches(FluidStack stack, FluidStack otherStack) {
            return FluidStack.areFluidsAndComponentsEqual(stack, otherStack);
        }
    }
}
