package com.zurrtum.create.infrastructure.component;

import com.google.common.base.Predicates;
import com.mojang.serialization.Codec;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.catnip.codecs.stream.CatnipStreamCodecBuilders;
import io.netty.buffer.ByteBuf;
import org.jetbrains.annotations.NotNull;

import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_3542;
import net.minecraft.class_5819;
import net.minecraft.class_9139;

public enum PlacementPatterns implements class_3542 {
    Solid,
    Checkered,
    InverseCheckered,
    Chance25,
    Chance50,
    Chance75;

    public static final Codec<PlacementPatterns> CODEC = class_3542.method_28140(PlacementPatterns::values);
    public static final class_9139<ByteBuf, PlacementPatterns> STREAM_CODEC = CatnipStreamCodecBuilders.ofEnum(PlacementPatterns.class);

    public final String translationKey;

    PlacementPatterns() {
        this.translationKey = name().toLowerCase(Locale.ROOT);
    }

    public static void applyPattern(List<class_2338> blocksIn, class_1799 stack, class_5819 random) {
        PlacementPatterns pattern = stack.method_58695(AllDataComponents.PLACEMENT_PATTERN, Solid);
        Predicate<class_2338> filter = Predicates.alwaysFalse();

        switch (pattern) {
            case Chance25:
                filter = pos -> random.method_43056() || random.method_43056();
                break;
            case Chance50:
                filter = pos -> random.method_43056();
                break;
            case Chance75:
                filter = pos -> random.method_43056() && random.method_43056();
                break;
            case Checkered:
                filter = pos -> (pos.method_10263() + pos.method_10264() + pos.method_10260()) % 2 == 0;
                break;
            case InverseCheckered:
                filter = pos -> (pos.method_10263() + pos.method_10264() + pos.method_10260()) % 2 != 0;
                break;
            case Solid:
            default:
                break;
        }

        blocksIn.removeIf(filter);
    }

    @Override
    public @NotNull String method_15434() {
        return translationKey;
    }
}
