package com.zurrtum.create.infrastructure.fluids;

import net.minecraft.block.*;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2402;
import net.minecraft.class_2404;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3621;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public abstract class FlowableFluid extends class_3621 {
    private final FluidEntry entry;

    FlowableFluid(FluidEntry entry) {
        this.entry = entry;
    }

    public FluidEntry getEntry() {
        return entry;
    }

    @Override
    public class_3611 method_15750() {
        return entry.flowing;
    }

    @Override
    public class_3611 method_15751() {
        return entry.still;
    }

    @Override
    public class_1792 method_15774() {
        if (entry.bucket == null) {
            return class_1802.field_8162;
        }
        return entry.bucket;
    }

    @Override
    public class_2680 method_15790(class_3610 state) {
        if (entry.block == null) {
            return class_2246.field_10124.method_9564();
        }
        return entry.block.method_9564().method_11657(class_2404.field_11278, method_15741(state));
    }

    @Override
    public void method_15776(class_1937 world, class_2338 pos, class_3610 state, class_5819 random) {
    }

    @Override
    @Nullable
    public class_2394 method_15787() {
        return null;
    }

    @Override
    public boolean method_15780(class_3611 fluid) {
        return fluid == entry.still || fluid == entry.flowing;
    }

    public static class Flowing extends FlowableFluid {
        public Flowing(FluidEntry entry) {
            super(entry);
        }

        @Override
        protected void method_15775(class_2689.class_2690<class_3611, class_3610> builder) {
            super.method_15775(builder);
            builder.method_11667(field_15900);
        }

        @Override
        public int method_15779(class_3610 state) {
            return state.method_11654(field_15900);
        }

        @Override
        public boolean method_15793(class_3610 state) {
            return false;
        }
    }

    public static class Still extends FlowableFluid {
        public Still(FluidEntry entry) {
            super(entry);
        }

        @Override
        public int method_15779(class_3610 state) {
            return 8;
        }

        @Override
        public boolean method_15793(class_3610 state) {
            return true;
        }
    }

    @Override
    protected void method_15745(class_1936 world, class_2338 pos, class_2680 state, class_2350 direction, class_3610 fluidState) {
        if (state.method_26204() instanceof class_2402 fluidFillable) {
            fluidFillable.method_10311(world, pos, state, fluidState);
        } else if (state.method_26227().method_15769()) {
            world.method_8652(pos, fluidState.method_15759(), class_2248.field_31036);
        }
    }

    @Override
    public int method_15739(class_4538 world) {
        return 2;
    }

    @Override
    public int method_15733(class_4538 world) {
        return 3;
    }

    @Override
    public int method_15789(class_4538 world) {
        return 25;
    }

    @Override
    protected boolean method_15737(class_3218 world) {
        return false;
    }

    @Override
    public boolean method_15777(class_3610 state, class_1922 world, class_2338 pos, class_3611 fluid, class_2350 direction) {
        return false;
    }
}
