package com.zurrtum.create.infrastructure.fluids;

import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public interface FluidInventoryProvider<T extends SmartBlockEntity> {
    default FluidInventory getFluidInventory(class_2680 state, class_1936 world, class_2338 pos) {
        return getFluidInventory(state, world, pos, null, null);
    }

    @SuppressWarnings("unchecked")
    default FluidInventory getFluidInventory(
        @Nullable class_2680 state,
        class_1936 world,
        class_2338 pos,
        @Nullable class_2586 blockEntity,
        class_2350 context
    ) {
        if (blockEntity == null) {
            if (state == null) {
                state = world.method_8320(pos);
            }
            if (state.method_31709()) {
                blockEntity = world.method_8321(pos);
            }
            if (blockEntity == null) {
                return null;
            }
        } else {
            if (state == null) {
                state = blockEntity.method_11010();
            }
        }
        Class<T> expectedClass = getBlockEntityClass();
        if (!expectedClass.isInstance(blockEntity))
            return null;
        return getFluidInventory(world, pos, state, (T) blockEntity, context);
    }

    Class<T> getBlockEntityClass();

    FluidInventory getFluidInventory(class_1936 world, class_2338 pos, class_2680 state, T blockEntity, class_2350 context);
}
