package com.zurrtum.create.infrastructure.items;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.*;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import org.apache.commons.lang3.mutable.MutableInt;

public class ItemStackHandler implements ItemInventory {
    public static final Codec<ItemStackHandler> CODEC = Codec.of(ItemStackHandler::encode, ItemStackHandler::decode);

    protected final class_2371<class_1799> stacks;

    public ItemStackHandler() {
        this(1);
    }

    public ItemStackHandler(int size) {
        this.stacks = class_2371.method_10213(size, class_1799.field_8037);
    }

    @Override
    public int method_5439() {
        return stacks.size();
    }

    @Override
    public class_1799 method_5438(int slot) {
        if (slot >= method_5439()) {
            return class_1799.field_8037;
        }
        return stacks.get(slot);
    }

    @Override
    public void method_5447(int slot, class_1799 stack) {
        if (slot >= method_5439()) {
            return;
        }
        stacks.set(slot, stack);
    }

    public class_2371<class_1799> getStacks() {
        return stacks;
    }

    public void writeSlots(class_11372 view) {
        view.method_71468("Inventory", CreateCodecs.ITEM_LIST_CODEC, stacks);
    }

    public void readSlots(class_11368 view) {
        view.method_71426("Inventory", CreateCodecs.ITEM_LIST_CODEC).ifPresentOrElse(
            list -> {
                for (int i = 0, size = list.size(); i < size; i++) {
                    stacks.set(i, list.get(i));
                }
            }, stacks::clear
        );
    }

    public void write(class_11372 view) {
        class_11372.class_11373<class_1799> list = view.method_71467("Inventory", class_1799.field_24671);
        for (class_1799 stack : stacks) {
            if (stack.method_7960()) {
                continue;
            }
            list.method_71484(stack);
        }
    }

    public void read(class_11368 view) {
        class_11368.class_11369<class_1799> list = view.method_71437("Inventory", class_1799.field_24671);
        int i = 0;
        for (class_1799 itemStack : list) {
            stacks.set(i++, itemStack);
        }
        for (int size = stacks.size(); i < size; i++) {
            stacks.set(i, class_1799.field_8037);
        }
    }

    private static <T> DataResult<T> encode(ItemStackHandler input, DynamicOps<T> ops, T prefix) {
        RecordBuilder<T> map = ops.mapBuilder();
        map.add("Size", ops.createInt(input.stacks.size()));
        ListBuilder<T> list = ops.listBuilder();
        for (class_1799 stack : input.stacks) {
            if (stack.method_7960()) {
                continue;
            }
            list.add(class_1799.field_24671.encodeStart(ops, stack));
        }
        map.add("Stacks", list.build(ops.empty()));
        return map.build(prefix);
    }

    private static <T> DataResult<Pair<ItemStackHandler, T>> decode(DynamicOps<T> ops, T input) {
        MapLike<T> map = ops.getMap(input).getOrThrow();
        int size = ops.getNumberValue(map.get("Size")).getOrThrow().intValue();
        ItemStackHandler handler = new ItemStackHandler(size);
        MutableInt i = new MutableInt();
        ops.getList(map.get("Stacks")).getOrThrow().accept(item -> {
            handler.stacks.set(i.getAndIncrement(), class_1799.field_24671.parse(ops, item).result().orElse(class_1799.field_8037));
        });
        return DataResult.success(Pair.of(handler, ops.empty()));
    }
}
