package com.zurrtum.create.mixin;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import static com.zurrtum.create.Create.MOD_ID;

import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

@Mixin(class_7924.class)
public class RegistryKeysMixin {
    @Inject(method = "getPath(Lnet/minecraft/registry/RegistryKey;)Ljava/lang/String;", at = @At("HEAD"), cancellable = true)
    private static void getPath(class_5321<? extends class_2378<?>> registryRef, CallbackInfoReturnable<String> cir) {
        class_2960 id = registryRef.method_29177();
        if (id.method_12836().equals(MOD_ID)) {
            cir.setReturnValue(id.method_12832());
        }
    }

    @Inject(method = "getTagPath(Lnet/minecraft/registry/RegistryKey;)Ljava/lang/String;", at = @At("HEAD"), cancellable = true)
    private static void getTagPath(class_5321<? extends class_2378<?>> registryRef, CallbackInfoReturnable<String> cir) {
        class_2960 id = registryRef.method_29177();
        if (id.method_12836().equals(MOD_ID)) {
            cir.setReturnValue("tags/" + id.method_12832());
        }
    }
}
